/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Instance;
import com.aliyun.odps.InstanceFilter;
import com.aliyun.odps.Job;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.OdpsHooks;
import com.aliyun.odps.Task;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.JAXBUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

public class Instances
implements Iterable<Instance> {
    private Odps odps;
    private RestClient client;
    private String defaultRunningCluster;

    public String getDefaultRunningCluster() {
        return this.defaultRunningCluster;
    }

    public void setDefaultRunningCluster(String defaultRunningCluster) {
        this.defaultRunningCluster = defaultRunningCluster;
    }

    Instances(Odps odps) {
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    public Instance create(Job job) throws OdpsException {
        return this.create(this.getDefaultProjectName(), job);
    }

    public Instance create(Task task) throws OdpsException {
        return this.create(this.getDefaultProjectName(), task);
    }

    public Instance create(Task task, int priority) throws OdpsException {
        return this.create(this.getDefaultProjectName(), task, priority);
    }

    public Instance create(Task task, int priority, String runningCluster) throws OdpsException {
        return this.create(this.getDefaultProjectName(), task, priority, runningCluster);
    }

    public Instance get(String id) {
        return this.get(this.getDefaultProjectName(), id);
    }

    public Instance get(String projectName, String id) {
        Instance.TaskStatusModel model = new Instance.TaskStatusModel();
        model.name = id;
        return new Instance(projectName, model, null, this.odps);
    }

    public boolean exists(String id) throws OdpsException {
        return this.exists(this.getDefaultProjectName(), id);
    }

    public boolean exists(String projectName, String id) throws OdpsException {
        try {
            Instance i = this.get(projectName, id);
            i.reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    public Instance create(String projectName, Task task) throws OdpsException {
        Job job = new Job();
        job.addTask(task);
        return this.create(projectName, job);
    }

    public Instance create(String projectName, Task task, int priority) throws OdpsException {
        return this.create(projectName, task, priority, this.defaultRunningCluster);
    }

    public Instance create(String projectName, Task task, int priority, String runningCluster) throws OdpsException {
        Job job = new Job();
        job.addTask(task);
        if (priority < 0) {
            throw new OdpsException("Priority must more than or equal to zero.");
        }
        job.setPriority(priority);
        job.setRunningCluster(runningCluster);
        return this.create(projectName, job);
    }

    Instance create(String project, Job job) throws OdpsException {
        if (project == null) {
            throw new IllegalArgumentException("project required.");
        }
        if (job == null) {
            throw new IllegalArgumentException("Job required.");
        }
        if (job.getTasks().size() == 0) {
            throw new IllegalArgumentException("Tasks required.");
        }
        String guid = UUID.randomUUID().toString();
        for (Task t : job.getTasks()) {
            t.setProperty("uuid", guid);
            if (t.getName() != null) continue;
            throw new OdpsException("Task name required.");
        }
        OdpsHooks hooks = null;
        if (OdpsHooks.isEnabled()) {
            hooks = new OdpsHooks();
            hooks.before(job, this.odps);
        }
        AnonymousInstance i = new AnonymousInstance();
        i.job = job.model;
        String xml = null;
        try {
            xml = JAXBUtils.marshal(i, AnonymousInstance.class);
        }
        catch (JAXBException e) {
            throw new OdpsException(e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        String resource = ResourceBuilder.buildInstancesResource(project);
        Response resp = this.client.stringRequest(resource, "POST", null, headers, xml);
        String location = resp.getHeaders().get("Location");
        if (location == null || location.trim().length() == 0) {
            throw new OdpsException("Invalid response, Location header required.");
        }
        String instanceId = location.substring(location.lastIndexOf("/") + 1);
        HashMap<String, Instance.Result> results = new HashMap<String, Instance.Result>();
        if (resp.getStatus() == 200 && resp.getBody() != null && resp.getBody().length > 0) {
            try {
                Instance.InstanceResultModel result = JAXBUtils.unmarshal(resp, Instance.InstanceResultModel.class);
                for (Instance.InstanceResultModel.TaskResult r : result.taskResults) {
                    results.put(r.name, r.result);
                }
            }
            catch (JAXBException e) {
                throw new OdpsException("Invalid create instance response.", e);
            }
        }
        Instance.TaskStatusModel model = new Instance.TaskStatusModel();
        model.name = instanceId;
        Instance instance = new Instance(project, model, results, this.odps);
        instance.setOdpsHooks(hooks);
        return instance;
    }

    private String getDefaultProjectName() {
        String project = this.client.getDefaultProject();
        if (project == null || project.length() == 0) {
            throw new RuntimeException("No default project specified.");
        }
        return project;
    }

    @Override
    public Iterator<Instance> iterator() {
        return this.iterator(this.getDefaultProjectName());
    }

    public Iterator<Instance> iterator(String project) {
        return this.iterator(project, null);
    }

    public Iterator<Instance> iterator(InstanceFilter filter) {
        return this.iterator(this.getDefaultProjectName(), filter);
    }

    public Iterator<Instance> iterator(final String project, final InstanceFilter filter) {
        return new ListIterator<Instance>(){
            Map<String, String> params = new HashMap<String, String>();

            @Override
            protected List<Instance> list() {
                ArrayList<Instance> instances = new ArrayList<Instance>();
                String lastMarker = this.params.get("marker");
                if (this.params.containsKey("marker") && lastMarker.length() == 0) {
                    return null;
                }
                if (filter != null) {
                    if (filter.getStatus() != null) {
                        this.params.put("status", filter.getStatus().toString());
                    }
                    StringBuilder range = new StringBuilder();
                    Date from = filter.getFromTime();
                    Date end = filter.getEndTime();
                    if (from != null) {
                        range.append(from.getTime() / 1000L);
                    }
                    if (from != null || end != null) {
                        range.append(':');
                    }
                    if (end != null) {
                        range.append(end.getTime() / 1000L);
                    }
                    if (range.length() > 0) {
                        this.params.put("daterange", range.toString());
                    }
                    if (filter.getOnlyOwner() != null) {
                        this.params.put("onlyowner", filter.getOnlyOwner() != false ? "yes" : "no");
                    }
                }
                String resource = ResourceBuilder.buildInstancesResource(project);
                try {
                    ListInstanceResponse resp = Instances.this.client.request(ListInstanceResponse.class, resource, "GET", this.params);
                    for (Instance.TaskStatusModel model : resp.instances) {
                        Instance t = new Instance(project, model, null, Instances.this.odps);
                        instances.add(t);
                    }
                    this.params.put("marker", resp.marker);
                }
                catch (OdpsException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                return instances;
            }
        };
    }

    @XmlRootElement(name="Instance")
    private static class AnonymousInstance {
        @XmlElement(name="Job")
        Job.JobModel job;

        private AnonymousInstance() {
        }
    }

    @XmlRootElement(name="Instances")
    private static class ListInstanceResponse {
        @XmlElement(name="Marker")
        private String marker;
        @XmlElement(name="MaxItems")
        private Integer maxItems;
        @XmlElement(name="Instance")
        private List<Instance.TaskStatusModel> instances = new ArrayList<Instance.TaskStatusModel>();

        private ListInstanceResponse() {
        }
    }
}

