/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.security.SecurityManager;
import com.aliyun.odps.utils.StringUtils;

public class LogView {
    private static final String POLICY_TYPE = "BEARER";
    private static final String HOST_DEFAULT = "http://logview.odps.aliyun.com";
    private String logViewHost = "http://logview.odps.aliyun.com";
    Odps odps;

    public LogView(Odps odps) {
        this.odps = odps;
        if (odps.getLogViewHost() != null) {
            this.logViewHost = odps.getLogViewHost();
        }
    }

    public String getLogViewHost() {
        return this.logViewHost;
    }

    public void setLogViewHost(String logViewHost) {
        this.logViewHost = logViewHost;
    }

    public String generateLogView(Instance instance, long hours) throws OdpsException {
        if (StringUtils.isNullOrEmpty((String)this.logViewHost)) {
            return "";
        }
        SecurityManager sm = this.odps.projects().get(instance.getProject()).getSecurityManager();
        String policy = this.generatePolicy(instance, hours);
        String token = sm.generateAuthorizationToken(policy, POLICY_TYPE);
        String logview = this.logViewHost + "/logview/?h=" + this.odps.getEndpoint() + "&p=" + instance.getProject() + "&i=" + instance.getId() + "&token=" + token;
        return logview;
    }

    private String generatePolicy(Instance instance, long hours) {
        String policy = "{\n    \"expires_in_hours\": " + String.valueOf(hours) + ",\n" + "    \"policy\": {\n" + "        \"Statement\": [{\n" + "            \"Action\": [\"odps:Read\"],\n" + "            \"Effect\": \"Allow\",\n" + "            \"Resource\": \"acs:odps:*:projects/" + instance.getProject() + "/instances/" + instance.getId() + "\"\n" + "        }],\n" + "        \"Version\": \"1\"\n" + "    }\n" + "}";
        return policy;
    }
}

