/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.ReloadException;
import com.aliyun.odps.commons.util.JacksonParser;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.JsonNode;

public class Partition
extends LazyLoad {
    private PartitionModel model;
    private PartitionSpec spec;
    private String project;
    private String table;
    private RestClient client;
    private Date createdTime;
    private Date lastMetaModifiedTime;
    private Date lastDataModifiedTime;
    private long size;
    private boolean isExtendInfoLoaded;
    private boolean isArchived;
    private boolean isExstore;
    private long lifeCycle;
    private long physicalSize;
    private long fileNum;

    Partition(PartitionModel model, String projectName, String tableName, RestClient client) {
        this.model = model;
        this.client = client;
        this.project = projectName;
        this.table = tableName;
        this.isArchived = false;
        this.isExstore = false;
        this.isExtendInfoLoaded = false;
        this.lifeCycle = -1L;
        this.physicalSize = 0L;
        this.fileNum = 0L;
    }

    Partition(PartitionSpec spec, String projectName, String tableName, RestClient client) {
        this.spec = spec;
        this.client = client;
        this.project = projectName;
        this.table = tableName;
        this.isArchived = false;
        this.isExstore = false;
        this.isExtendInfoLoaded = false;
        this.lifeCycle = -1L;
        this.physicalSize = 0L;
        this.fileNum = 0L;
    }

    public PartitionSpec getPartitionSpec() {
        if (this.spec != null) {
            return this.spec;
        }
        this.spec = new PartitionSpec();
        for (ColumnModel c : this.model.columns) {
            this.spec.set(c.columnName, c.columnValue);
        }
        return this.spec;
    }

    public Date getCreatedTime() {
        this.lazyLoad();
        return this.createdTime;
    }

    public Date getLastMetaModifiedTime() {
        this.lazyLoad();
        return this.lastMetaModifiedTime;
    }

    public Date getLastDataModifiedTime() {
        this.lazyLoad();
        return this.lastDataModifiedTime;
    }

    public boolean isArchived() {
        this.lazyLoadExtendInfo();
        return this.isArchived;
    }

    public boolean isExstore() {
        this.lazyLoadExtendInfo();
        return this.isExstore;
    }

    public long getLifeCycle() {
        this.lazyLoadExtendInfo();
        return this.lifeCycle;
    }

    public long getPhysicalSize() {
        this.lazyLoadExtendInfo();
        return this.physicalSize;
    }

    public long getFileNum() {
        this.lazyLoadExtendInfo();
        return this.fileNum;
    }

    public long getSize() {
        this.lazyLoad();
        return this.size;
    }

    @Override
    public void reload() throws OdpsException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("partition", this.getPartitionSpec().toString());
        String resource = ResourceBuilder.buildTableResource(this.project, this.table);
        PartitionMeta meta = this.client.request(PartitionMeta.class, resource.toString(), "GET", params);
        try {
            JsonNode tree = JacksonParser.parse(meta.schema);
            JsonNode node = tree.get("createTime");
            if (node != null && !node.isNull()) {
                this.createdTime = new Date(node.asLong() * 1000L);
            }
            if ((node = tree.get("lastDDLTime")) != null && !node.isNull()) {
                this.lastMetaModifiedTime = new Date(node.asLong() * 1000L);
            }
            if ((node = tree.get("lastModifiedTime")) != null && !node.isNull()) {
                this.lastDataModifiedTime = new Date(node.asLong() * 1000L);
            }
            if ((node = tree.get("partitionSize")) != null && !node.isNull()) {
                this.size = node.asLong();
            }
            this.setLoaded(true);
        }
        catch (Exception e) {
            throw new OdpsException("Invalid partition meta", e);
        }
    }

    private void lazyLoadExtendInfo() {
        if (!this.isExtendInfoLoaded) {
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            params.put("extended", null);
            params.put("partition", this.getPartitionSpec().toString());
            String resource = ResourceBuilder.buildTableResource(this.project, this.table);
            try {
                PartitionMeta meta = this.client.request(PartitionMeta.class, resource.toString(), "GET", params);
                JsonNode tree = JacksonParser.parse(meta.schema);
                JsonNode node = tree.get("IsArchived");
                if (node != null && !node.isNull()) {
                    this.isArchived = node.asBoolean();
                }
                if ((node = tree.get("IsExstore")) != null && !node.isNull()) {
                    this.isExstore = node.asBoolean();
                }
                if ((node = tree.get("LifeCycle")) != null && !node.isNull()) {
                    this.lifeCycle = node.asLong();
                }
                if ((node = tree.get("PhysicalSize")) != null && !node.isNull()) {
                    this.physicalSize = node.asLong();
                }
                if ((node = tree.get("FileNum")) != null && !node.isNull()) {
                    this.fileNum = node.asLong();
                }
            }
            catch (Exception e) {
                throw new ReloadException(e.getMessage(), e);
            }
            this.isExtendInfoLoaded = true;
        }
    }

    @XmlRootElement(name="Partition")
    private static class PartitionMeta {
        @XmlElement(name="Schema")
        private String schema;

        private PartitionMeta() {
        }
    }

    @XmlRootElement(name="Column")
    static class ColumnModel {
        @XmlAttribute(name="Name")
        private String columnName;
        @XmlAttribute(name="Value")
        private String columnValue;

        ColumnModel() {
        }
    }

    @XmlRootElement(name="Partition")
    static class PartitionModel {
        @XmlElement(name="Column")
        private List<ColumnModel> columns = new ArrayList<ColumnModel>();

        PartitionModel() {
        }
    }
}

