/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.account;

import com.aliyun.odps.account.RequestSigner;
import com.aliyun.odps.account.SecurityUtils;
import com.aliyun.odps.commons.transport.Request;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;

class AliyunRequestSigner
implements RequestSigner {
    private static final Logger log = Logger.getLogger(AliyunRequestSigner.class.getName());
    private String accessId;
    private String accessKey;

    public AliyunRequestSigner(String accessId, String accessKey) {
        if (accessId == null || accessId.length() == 0) {
            throw new IllegalArgumentException("AccessId should not be empty.");
        }
        if (accessKey == null || accessKey.length() == 0) {
            throw new IllegalArgumentException("AccessKey should not be empty.");
        }
        this.accessId = accessId;
        this.accessKey = accessKey;
    }

    @Override
    public void sign(String resource, Request req) {
        try {
            resource = URLDecoder.decode(resource, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        String strToSign = SecurityUtils.buildCanonicalString(resource, req, "x-odps-");
        if (log.isLoggable(Level.FINE)) {
            log.fine("String to sign: " + strToSign);
        }
        byte[] crypto = SecurityUtils.hmacsha1Signature(strToSign.getBytes(), this.accessKey.getBytes());
        String signature = Base64.encodeBase64String((byte[])crypto).trim();
        req.getHeaders().put("Authorization", "ODPS " + this.accessId + ":" + signature);
    }
}

