/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel;

import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.DefaultTransport;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.JacksonParser;
import com.aliyun.odps.data.RecordReader;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.Configuration;
import com.aliyun.odps.tunnel.DownloadSession$AjcClosure1;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.TunnelTableSchema;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

@Deprecated
public class DownloadSession {
    private String id;
    private String projectName;
    private String tableName;
    private String partitionSpec;
    private long count;
    private TableSchema schema = new TableSchema();
    private Status status = Status.UNKNOWN;
    private Configuration conf;
    private RestClient tunnelServiceClient;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    DownloadSession(Configuration conf, String projectName, String tableName, String partitionSpec) throws TunnelException {
        this.conf = conf;
        this.projectName = projectName;
        this.tableName = tableName;
        this.partitionSpec = partitionSpec;
        this.tunnelServiceClient = new RestClient(new DefaultTransport());
        this.tunnelServiceClient.setAccount(conf.getAccount());
        this.tunnelServiceClient.setEndpoint(conf.getEndpoint(projectName).toString());
        this.tunnelServiceClient.setUserAgent(conf.getUserAgent());
        this.tunnelServiceClient.setReadTimeout(conf.getSocketTimeout());
        this.tunnelServiceClient.setConnectTimeout(conf.getSocketConnectTimeout());
        this.initiate();
    }

    DownloadSession(Configuration conf, String projectName, String tableName, String partitionSpec, String downloadId) throws TunnelException {
        this.conf = conf;
        this.projectName = projectName;
        this.tableName = tableName;
        this.partitionSpec = partitionSpec;
        this.id = downloadId;
        this.tunnelServiceClient = new RestClient(new DefaultTransport());
        this.tunnelServiceClient.setAccount(conf.getAccount());
        this.tunnelServiceClient.setEndpoint(conf.getEndpoint(projectName).toString());
        this.tunnelServiceClient.setUserAgent(conf.getUserAgent());
        this.tunnelServiceClient.setReadTimeout(conf.getSocketTimeout());
        this.tunnelServiceClient.setConnectTimeout(conf.getSocketConnectTimeout());
        this.reload();
    }

    public RecordReader openRecordReader(long start, long count) throws TunnelException, IOException {
        return this.openRecordReader(start, count, false);
    }

    public RecordReader openRecordReader(long start, long count, boolean compress) throws TunnelException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Length", String.valueOf(0));
        headers.put("x-odps-tunnel-version", String.valueOf(4));
        if (compress) {
            if (this.conf.getCompressOption().algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_ZLIB)) {
                headers.put("Accept-Encoding", "deflate");
            } else {
                throw new TunnelException("invalid compression option.");
            }
        }
        params.put("downloadid", this.id);
        params.put("data", null);
        params.put("rowrange", "(" + start + "," + count + ")");
        if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
            params.put("partition", this.partitionSpec);
        }
        TunnelRecordReader reader = null;
        Connection conn = null;
        try {
            conn = this.tunnelServiceClient.connect(this.getResource(), "GET", params, headers);
            Response resp = conn.getResponse();
            if (!resp.isOK()) {
                TunnelException err = new TunnelException(conn.getInputStream());
                err.setRequestId(resp.getHeader("x-odps-request-id"));
                throw new IOException(err);
            }
            String content_encoding = resp.getHeader("Content-Encoding");
            if (content_encoding != null) {
                if (!resp.getHeader("Content-Encoding").equals("deflate")) {
                    throw new TunnelException("invalid content encoding");
                }
                this.conf.setCompressOption(new CompressOption(CompressOption.CompressAlgorithm.ODPS_ZLIB, -1, 0));
                compress = true;
            } else {
                compress = false;
            }
            CompressOption option = compress ? this.conf.getCompressOption() : null;
            reader = new TunnelRecordReader(this.schema, conn, option);
        }
        catch (IOException e) {
            if (conn != null) {
                conn.disconnect();
            }
            throw new TunnelException(e.getMessage(), e);
        }
        catch (TunnelException e) {
            throw e;
        }
        catch (OdpsException e) {
            if (conn != null) {
                conn.disconnect();
            }
            throw new TunnelException(e.getMessage(), e);
        }
        return reader;
    }

    private void initiate() throws TunnelException {
        block14: {
            HashMap<String, String> params = new HashMap<String, String>();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Length", String.valueOf(0));
            params.put("downloads", null);
            if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
                params.put("partition", this.partitionSpec);
            }
            Connection conn = null;
            try {
                conn = this.tunnelServiceClient.connect(this.getResource(), "POST", params, headers);
                Response resp = conn.getResponse();
                if (resp.isOK()) {
                    this.loadFromJson(conn.getInputStream());
                    break block14;
                }
                TunnelException e = new TunnelException(conn.getInputStream());
                e.setRequestId(resp.getHeader("x-odps-request-id"));
                throw e;
            }
            catch (IOException e) {
                throw new TunnelException(e.getMessage(), e);
            }
            catch (TunnelException e) {
                throw e;
            }
            catch (OdpsException e) {
                throw new TunnelException(e.getMessage(), e);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.disconnect();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private void reload() throws TunnelException {
        block14: {
            HashMap<String, String> params = new HashMap<String, String>();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Length", String.valueOf(0));
            params.put("downloadid", this.id);
            if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
                params.put("partition", this.partitionSpec);
            }
            Connection conn = null;
            try {
                conn = this.tunnelServiceClient.connect(this.getResource(), "GET", params, headers);
                Response resp = conn.getResponse();
                if (resp.isOK()) {
                    this.loadFromJson(conn.getInputStream());
                    break block14;
                }
                TunnelException e = new TunnelException(conn.getInputStream());
                e.setRequestId(resp.getHeader("x-odps-request-id"));
                throw e;
            }
            catch (IOException e) {
                throw new TunnelException(e.getMessage(), e);
            }
            catch (TunnelException e) {
                throw e;
            }
            catch (OdpsException e) {
                throw new TunnelException(e.getMessage(), e);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.disconnect();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    public TableSchema getSchema() {
        return this.schema;
    }

    public long getRecordCount() {
        return this.count;
    }

    public String getId() {
        return this.id;
    }

    public Status getStatus() throws TunnelException, IOException {
        this.reload();
        return this.status;
    }

    private String getResource() {
        return this.conf.getResource(this.projectName, this.tableName);
    }

    private void loadFromJson(InputStream is) throws TunnelException {
        try {
            ObjectMapper mapper = JacksonParser.getObjectMapper();
            JsonNode tree = mapper.readTree(is);
            JsonNode node = tree.get("DownloadID");
            if (node != null && !node.isNull()) {
                this.id = node.asText();
            }
            if ((node = tree.get("Status")) != null && !node.isNull()) {
                this.status = Status.valueOf(node.asText().toUpperCase());
            }
            if ((node = tree.get("RecordCount")) != null && !node.isNull()) {
                this.count = node.asLong();
            }
            if ((node = tree.get("Schema")) != null && !node.isNull()) {
                this.schema = new TunnelTableSchema(node);
            }
        }
        catch (Exception e) {
            throw new TunnelException("Invalid json content.", e);
        }
    }

    static {
        DownloadSession.ajc$preClinit();
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        OdpsDeprecatedLogger.aspectOf().around(new DownloadSession$AjcClosure1(objectArray).linkClosureAndJoinPoint(65536));
    }

    static /* synthetic */ void clinit$_aroundBody0(JoinPoint joinPoint) {
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DownloadSession.java", DownloadSession.class);
        ajc$tjp_0 = factory.makeSJP("staticinitialization", (Signature)factory.makeInitializerSig("8", "com.aliyun.odps.tunnel.DownloadSession"), 0);
    }

    public static enum Status {
        UNKNOWN,
        NORMAL,
        CLOSED,
        EXPIRED;

    }
}

