/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.JacksonParser;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.Configuration;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.TunnelTableSchema;
import com.aliyun.odps.tunnel.io.StreamUploadWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class StreamUploadClient {
    private String projectName;
    private String tableName;
    private TunnelTableSchema schema;
    private Configuration conf;
    private RestClient tunnelServiceClient;
    private HashMap<String, String> headers;

    StreamUploadClient(Configuration conf, String projectName, String tableName) throws TunnelException {
        this.conf = conf;
        this.projectName = projectName;
        this.tableName = tableName;
        this.headers = new HashMap();
        this.headers.put("Content-Length", "0");
        this.headers.put("x-odps-tunnel-stream-version", "1");
        this.initiate();
    }

    private void initiate() throws TunnelException {
        block13: {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("query", "meta");
            this.tunnelServiceClient = this.conf.newRestClient(this.projectName);
            Connection conn = null;
            try {
                conn = this.tunnelServiceClient.connect(this.getResource(), "GET", param, this.headers);
                Response resp = conn.getResponse();
                if (resp.isOK()) {
                    this.loadFromJson(conn.getInputStream());
                    break block13;
                }
                TunnelException ex = new TunnelException(conn.getInputStream());
                ex.setRequestId(resp.getHeader("x-odps-request-id"));
                throw ex;
            }
            catch (TunnelException e) {
                throw e;
            }
            catch (OdpsException e) {
                throw new TunnelException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new TunnelException(e.getMessage(), e);
            }
            finally {
                if (null != conn) {
                    try {
                        conn.disconnect();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
    }

    public StreamUploadWriter openStreamUploadWriter() throws TunnelException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> headers = new HashMap<String, String>(this.headers);
        headers.put("Content-Type", "application/octet-stream");
        headers.put("x-odps-tunnel-version", String.valueOf(4));
        return new StreamUploadWriter(this.tunnelServiceClient, this.getStreamResource(), params, headers);
    }

    public TableSchema getStreamSchema() {
        return this.schema;
    }

    private void loadFromJson(InputStream is) throws TunnelException {
        try {
            ObjectMapper mapper = JacksonParser.getObjectMapper();
            JsonNode tree = mapper.readTree(is);
            JsonNode node = tree.get("Schema");
            if (null == node || node.isNull()) {
                throw new TunnelException("Get table type failed");
            }
            this.schema = new TunnelTableSchema(node);
        }
        catch (Exception e) {
            throw new TunnelException("Invalid json content.", e);
        }
    }

    private String getResource() {
        return this.conf.getResource(this.projectName, this.tableName);
    }

    private String getStreamResource() {
        return this.conf.getStreamUploadResource(this.projectName, this.tableName);
    }
}

