/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.aliyun.odps.commons.util.JacksonParser;
import com.aliyun.odps.tunnel.TunnelException;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class ReplicatorStatus {
    private String lastReplicatedPackId;
    private long lastReplicatedPackTimeStamp;

    public ReplicatorStatus(InputStream is) throws TunnelException, IOException {
        ObjectMapper mapper = JacksonParser.getObjectMapper();
        JsonNode tree = mapper.readTree(is);
        JsonNode node = null;
        node = tree.get("LastReplicatedPackId");
        if (node == null || node.isNull()) {
            throw new TunnelException("get last replicated packid fail");
        }
        this.lastReplicatedPackId = node.getTextValue();
        node = tree.get("LastReplicatedPackTimeStamp");
        if (node == null || node.isNull()) {
            throw new TunnelException("get last replicated pack timestamp fail");
        }
        this.lastReplicatedPackTimeStamp = node.getLongValue();
    }

    public String GetLastReplicatedPackId() {
        return this.lastReplicatedPackId;
    }

    public long GetLastReplicatedPackTimeStamp() {
        return this.lastReplicatedPackTimeStamp;
    }
}

