/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Function;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.utils.NameSpaceSchemaUtils;
import com.aliyun.odps.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Functions
implements Iterable<Function> {
    private RestClient client;
    private Odps odps;

    Functions(Odps odps) {
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    public Function get(String functionName) throws OdpsException {
        return this.get(this.odps.getDefaultProject(), functionName);
    }

    public Function get(String projectName, String functionName) {
        return this.get(projectName, this.odps.getCurrentSchema(), functionName);
    }

    public Function get(String projectName, String schemaName, String functionName) {
        if (StringUtils.isNullOrEmpty((String)projectName)) {
            throw new IllegalArgumentException("Argument 'projectName' cannot be null or empty");
        }
        if (StringUtils.isNullOrEmpty((String)functionName)) {
            throw new IllegalArgumentException("Argument 'functionName' cannot be null or empty");
        }
        Function.FunctionModel model = new Function.FunctionModel();
        model.schemaName = schemaName;
        model.name = functionName;
        return new Function(model, projectName, this.odps);
    }

    public boolean exists(String functionName) throws OdpsException {
        return this.exists(this.odps.getDefaultProject(), functionName);
    }

    public boolean exists(String projectName, String functionName) throws OdpsException {
        return this.exists(projectName, this.odps.getCurrentSchema(), functionName);
    }

    public boolean exists(String projectName, String schemaName, String functionName) throws OdpsException {
        Function function = this.get(projectName, schemaName, functionName);
        try {
            function.reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    public void update(Function func) throws OdpsException {
        this.update(this.odps.getDefaultProject(), func);
    }

    public void update(String projectName, Function func) throws OdpsException {
        this.update(projectName, this.odps.getCurrentSchema(), func);
    }

    public void update(String projectName, String schemaName, Function function) throws OdpsException {
        String body;
        if (StringUtils.isNullOrEmpty((String)projectName)) {
            throw new IllegalArgumentException("Argument 'projectName' cannot be null or empty");
        }
        if (StringUtils.isNullOrEmpty((String)function.getName())) {
            throw new IllegalArgumentException("Argument 'function' is invalid. Its name is null or empty");
        }
        String resource = ResourceBuilder.buildFunctionResource(projectName, function.getName());
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/xml");
        HashMap<String, String> params = NameSpaceSchemaUtils.initParamsWithSchema(schemaName);
        try {
            body = SimpleXmlUtils.marshal(function.model);
        }
        catch (Exception e) {
            throw new OdpsException(e);
        }
        this.client.stringRequest(resource, "PUT", params, header, body);
    }

    public void create(Function func) throws OdpsException {
        this.create(this.odps.getDefaultProject(), func);
    }

    public void create(String projectName, Function func) throws OdpsException {
        this.create(projectName, this.odps.getCurrentSchema(), func);
    }

    public void create(String projectName, String schemaName, Function function) throws OdpsException {
        String body;
        if (StringUtils.isNullOrEmpty((String)projectName)) {
            throw new IllegalArgumentException("Argument 'projectName' cannot be null or empty");
        }
        if (StringUtils.isNullOrEmpty((String)function.getName())) {
            throw new IllegalArgumentException("Argument 'function' is invalid. Its name is null or empty");
        }
        String resource = ResourceBuilder.buildFunctionsResource(projectName);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/xml");
        HashMap<String, String> params = NameSpaceSchemaUtils.initParamsWithSchema(schemaName);
        try {
            body = SimpleXmlUtils.marshal(function.model);
        }
        catch (Exception e) {
            throw new OdpsException(e);
        }
        this.client.stringRequest(resource, "POST", params, header, body);
    }

    public void delete(String name) throws OdpsException {
        this.delete(this.odps.getDefaultProject(), name);
    }

    public void delete(String projectName, String name) throws OdpsException {
        String resource = ResourceBuilder.buildFunctionResource(projectName, name);
        this.client.request(resource, "DELETE", null, null, null);
    }

    public void delete(String projectName, String schemaName, String functionName) throws OdpsException {
        if (StringUtils.isNullOrEmpty((String)projectName)) {
            throw new IllegalArgumentException("Argument 'projectName' cannot be null or empty");
        }
        if (StringUtils.isNullOrEmpty((String)functionName)) {
            throw new IllegalArgumentException("Argument 'functionName' cannot be null or empty");
        }
        String resource = ResourceBuilder.buildFunctionResource(projectName, functionName);
        HashMap<String, String> params = NameSpaceSchemaUtils.initParamsWithSchema(schemaName);
        this.client.request(resource, "DELETE", params, null, null);
    }

    @Override
    public Iterator<Function> iterator() {
        return this.iterator(this.odps.getDefaultProject());
    }

    public Iterator<Function> iterator(String projectName) {
        return this.iterator(projectName, this.odps.getCurrentSchema());
    }

    public Iterator<Function> iterator(String projectName, String schemaName) {
        return new FunctionListIterator(projectName, schemaName);
    }

    public Iterator<Function> iterator(String projectName, String schemaName, String functionName) {
        return new FunctionListIterator(projectName, schemaName, functionName);
    }

    public Iterable<Function> iterable() {
        return this.iterable(this.odps.getDefaultProject());
    }

    public Iterable<Function> iterable(String projectName) {
        return this.iterable(projectName, this.odps.getCurrentSchema());
    }

    public Iterable<Function> iterable(String projectName, String schemaName) {
        return () -> new FunctionListIterator(projectName, schemaName);
    }

    public Iterable<Function> iterable(String projectName, String schemaName, String functionName) {
        return () -> new FunctionListIterator(projectName, schemaName, functionName);
    }

    private class FunctionListIterator
    extends ListIterator<Function> {
        Map<String, String> params = new HashMap<String, String>();
        String projectName;
        String schemaName;
        String functionName;

        FunctionListIterator(String projectName, String schemaName, String functionName) {
            if (StringUtils.isNullOrEmpty((String)projectName)) {
                throw new IllegalArgumentException("Argument 'projectName' cannot be null or empty");
            }
            this.projectName = projectName;
            this.schemaName = schemaName;
            this.params = NameSpaceSchemaUtils.initParamsWithSchema(schemaName);
            this.functionName = functionName;
        }

        public FunctionListIterator(String projectName, String schemaName) {
            this(projectName, schemaName, null);
        }

        @Override
        public List<Function> list(String marker, long maxItems) {
            if (marker != null) {
                this.params.put("marker", marker);
            }
            if (maxItems >= 0L) {
                this.params.put("maxitems", String.valueOf(maxItems));
            }
            return this.list();
        }

        @Override
        public String getMarker() {
            return this.params.get("marker");
        }

        @Override
        protected List<Function> list() {
            ArrayList<Function> functions = new ArrayList<Function>();
            this.params.put("expectmarker", "true");
            String lastMarker = this.params.get("marker");
            if (this.params.containsKey("marker") && StringUtils.isNullOrEmpty((String)lastMarker)) {
                return null;
            }
            if (this.functionName != null) {
                this.params.put("name", this.functionName);
            }
            String resource = ResourceBuilder.buildFunctionsResource(this.projectName);
            try {
                ListFunctionsResponse resp = Functions.this.client.request(ListFunctionsResponse.class, resource, "GET", this.params);
                for (Function.FunctionModel model : resp.functions) {
                    model.schemaName = this.schemaName;
                    Function t = new Function(model, this.projectName, Functions.this.odps);
                    functions.add(t);
                }
                this.params.put("marker", resp.marker);
            }
            catch (OdpsException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return functions;
        }
    }

    @Root(name="Functions", strict=false)
    static class ListFunctionsResponse {
        @ElementList(entry="Function", inline=true, required=false)
        List<Function.FunctionModel> functions = new ArrayList<Function.FunctionModel>();
        @Element(name="Marker", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String marker;
        @Element(name="MaxItems", required=false)
        Integer maxItems;

        ListFunctionsResponse() {
        }
    }
}

