/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.ReloadException;
import com.aliyun.odps.Table;
import com.aliyun.odps.Tag;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Attribute;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.utils.NameSpaceSchemaUtils;
import com.aliyun.odps.utils.TagUtils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Partition
extends LazyLoad {
    private PartitionModel model;
    private TagUtils.ObjectTagInfo partitionTagInfo;
    private PartitionSpec spec;
    private String projectName;
    private String schemaName;
    private String table;
    private Odps odps;
    private RestClient client;
    protected long size;
    protected long recordNum = -1L;
    private boolean isExtendInfoLoaded;
    private boolean isArchived;
    private boolean isExstore;
    private long lifeCycle;
    private long physicalSize;
    private long fileNum;
    private String reserved;
    private Table.ClusterInfo clusterInfo;

    Partition(PartitionModel model, String projectName, String schemaName, String tableName, Odps odps) {
        this.model = model;
        this.odps = odps;
        this.client = odps.getRestClient();
        this.projectName = projectName;
        this.schemaName = schemaName;
        this.table = tableName;
        this.isArchived = false;
        this.isExstore = false;
        this.isExtendInfoLoaded = false;
        this.lifeCycle = -1L;
        this.physicalSize = 0L;
        this.fileNum = 0L;
    }

    Partition(PartitionSpec spec, String projectName, String schemaName, String tableName, Odps odps) {
        this.spec = spec;
        this.odps = odps;
        this.client = odps.getRestClient();
        this.projectName = projectName;
        this.schemaName = schemaName;
        this.table = tableName;
        this.isArchived = false;
        this.isExstore = false;
        this.isExtendInfoLoaded = false;
        this.lifeCycle = -1L;
        this.physicalSize = 0L;
        this.fileNum = 0L;
        this.model = new PartitionModel();
    }

    public PartitionSpec getPartitionSpec() {
        if (this.spec != null) {
            return this.spec;
        }
        this.spec = new PartitionSpec();
        for (ColumnModel c : this.model.columns) {
            this.spec.set(c.columnName, c.columnValue);
        }
        return this.spec;
    }

    public Date getCreatedTime() {
        if (this.model == null || this.model.createdTime == null) {
            this.lazyLoad();
        }
        return this.model.createdTime;
    }

    public Date getLastMetaModifiedTime() {
        if (this.model == null || this.model.lastMetaModifiedTime == null) {
            this.lazyLoad();
        }
        return this.model.lastMetaModifiedTime;
    }

    public Date getLastDataModifiedTime() {
        if (this.model == null || this.model.lastDataModifiedTime == null) {
            this.lazyLoad();
        }
        return this.model.lastDataModifiedTime;
    }

    public Date getLastDataAccessTime() {
        if (this.model == null || this.model.lastAccessTime == null) {
            this.lazyLoad();
        }
        return this.model.lastAccessTime;
    }

    public long getRecordNum() {
        this.lazyLoad();
        return this.recordNum;
    }

    public boolean isArchived() {
        this.lazyLoadExtendInfo();
        return this.isArchived;
    }

    public boolean isExstore() {
        this.lazyLoadExtendInfo();
        return this.isExstore;
    }

    public long getLifeCycle() {
        this.lazyLoadExtendInfo();
        return this.lifeCycle;
    }

    public long getPhysicalSize() {
        this.lazyLoadExtendInfo();
        return this.physicalSize;
    }

    public long getFileNum() {
        this.lazyLoadExtendInfo();
        return this.fileNum;
    }

    public long getSize() {
        this.lazyLoad();
        return this.size;
    }

    public String getReserved() {
        if (this.reserved == null) {
            this.lazyLoadExtendInfo();
        }
        return this.reserved;
    }

    public Table.ClusterInfo getClusterInfo() {
        if (this.clusterInfo == null) {
            this.lazyLoadExtendInfo();
        }
        return this.clusterInfo;
    }

    public List<Tag> getTags() {
        this.reloadTagInfo();
        return TagUtils.getTags(this.partitionTagInfo, this.odps);
    }

    public List<Tag> getTags(String columnName) {
        this.reloadTagInfo();
        Objects.requireNonNull(columnName);
        TagUtils.validateTaggingColumn(this.odps.tables().get(this.projectName, this.table).getSchema(), Collections.singletonList(columnName));
        return TagUtils.getTags(this.partitionTagInfo, columnName, this.odps);
    }

    public Map<String, Map<String, String>> getSimpleTags() {
        this.reloadTagInfo();
        return TagUtils.getSimpleTags(this.partitionTagInfo);
    }

    public Map<String, Map<String, String>> getSimpleTags(String columnName) {
        this.reloadTagInfo();
        Objects.requireNonNull(columnName);
        TagUtils.validateTaggingColumn(this.odps.tables().get(this.projectName, this.table).getSchema(), Collections.singletonList(columnName));
        return TagUtils.getSimpleTags(this.partitionTagInfo, columnName);
    }

    public void addTag(Tag tag) throws OdpsException {
        this.addTag(tag, null);
    }

    public void addTag(Tag tag, List<String> columnNames) throws OdpsException {
        TagUtils.ObjectRef objectRef = new TagUtils.ObjectRef(TagUtils.OBJECT_TYPE.TABLE, this.projectName, this.table, columnNames);
        TagUtils.TagRef tagRef = new TagUtils.TagRef(tag.getClassification(), tag.getName());
        TagUtils.SetObjectTagInput setObjectTagInput = new TagUtils.SetObjectTagInput(TagUtils.OPERATION_TYPE.SET, objectRef, tagRef, null);
        TagUtils.updateTagInternal(setObjectTagInput, this.getPartitionSpec(), this.client);
    }

    public void addSimpleTag(String category, String key, String value) throws OdpsException {
        this.addSimpleTag(category, key, value, null);
    }

    public void addSimpleTag(String category, String key, String value, List<String> columnNames) throws OdpsException {
        TagUtils.ObjectRef objectRef = new TagUtils.ObjectRef(TagUtils.OBJECT_TYPE.TABLE, this.projectName, this.table, columnNames);
        TagUtils.SimpleTag simpleTag = new TagUtils.SimpleTag(category, Collections.singletonMap(key, value));
        TagUtils.SetObjectTagInput setObjectTagInput = new TagUtils.SetObjectTagInput(TagUtils.OPERATION_TYPE.SET, objectRef, null, simpleTag);
        TagUtils.updateTagInternal(setObjectTagInput, this.getPartitionSpec(), this.client);
    }

    public void removeTag(Tag tag) throws OdpsException {
        this.removeTag(tag, null);
    }

    public void removeTag(Tag tag, List<String> columnNames) throws OdpsException {
        Objects.requireNonNull(tag);
        TagUtils.validateTaggingColumn(this.odps.tables().get(this.projectName, this.table).getSchema(), columnNames);
        TagUtils.ObjectRef objectRef = new TagUtils.ObjectRef(TagUtils.OBJECT_TYPE.TABLE, this.projectName, this.table, columnNames);
        TagUtils.TagRef tagRef = new TagUtils.TagRef(tag.getClassification(), tag.getName());
        TagUtils.SetObjectTagInput setObjectTagInput = new TagUtils.SetObjectTagInput(TagUtils.OPERATION_TYPE.UNSET, objectRef, tagRef, null);
        TagUtils.updateTagInternal(setObjectTagInput, this.getPartitionSpec(), this.client);
    }

    public void removeSimpleTag(String category, String key, String value) throws OdpsException {
        this.removeSimpleTag(category, key, value, null);
    }

    public void removeSimpleTag(String category, String key, String value, List<String> columnNames) throws OdpsException {
        Objects.requireNonNull(category);
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        TagUtils.validateTaggingColumn(this.odps.tables().get(this.projectName, this.table).getSchema(), columnNames);
        TagUtils.ObjectRef objectRef = new TagUtils.ObjectRef(TagUtils.OBJECT_TYPE.TABLE, this.projectName, this.table, columnNames);
        TagUtils.SimpleTag simpleTag = new TagUtils.SimpleTag(category, Collections.singletonMap(key, value));
        TagUtils.SetObjectTagInput setObjectTagInput = new TagUtils.SetObjectTagInput(TagUtils.OPERATION_TYPE.UNSET, objectRef, null, simpleTag);
        TagUtils.updateTagInternal(setObjectTagInput, this.getPartitionSpec(), this.client);
    }

    @Override
    public void reload() throws OdpsException {
        String resource = ResourceBuilder.buildTableResource(this.projectName, this.table);
        HashMap<String, String> params = NameSpaceSchemaUtils.initParamsWithSchema(this.schemaName);
        params.put("partition", this.getPartitionSpec().toString());
        PartitionMeta meta = this.client.request(PartitionMeta.class, resource, "GET", params);
        try {
            JsonObject tree = new JsonParser().parse(meta.schema).getAsJsonObject();
            if (tree.has("createTime")) {
                this.model.createdTime = new Date(tree.get("createTime").getAsLong() * 1000L);
            }
            if (tree.has("lastAccessTime")) {
                long timestamp = tree.get("lastAccessTime").getAsLong() * 1000L;
                Date date = this.model.lastAccessTime = timestamp == 0L ? null : new Date(timestamp);
            }
            if (tree.has("lastDDLTime")) {
                this.model.lastMetaModifiedTime = new Date(tree.get("lastDDLTime").getAsLong() * 1000L);
            }
            if (tree.has("lastModifiedTime")) {
                this.model.lastDataModifiedTime = new Date(tree.get("lastModifiedTime").getAsLong() * 1000L);
            }
            if (tree.has("partitionSize")) {
                this.size = tree.get("partitionSize").getAsLong();
            }
            if (tree.has("partitionRecordNum")) {
                this.recordNum = tree.get("partitionRecordNum").getAsLong();
            }
            this.setLoaded(true);
        }
        catch (Exception e) {
            throw new OdpsException("Invalid partition meta", e);
        }
    }

    private void reloadTagInfo() {
        String resource = ResourceBuilder.buildTableResource(this.projectName, this.table);
        try {
            this.partitionTagInfo = TagUtils.getObjectTagInfo(resource, this.getPartitionSpec(), this.client);
        }
        catch (OdpsException e) {
            throw new ReloadException(e);
        }
    }

    private void lazyLoadExtendInfo() {
        if (!this.isExtendInfoLoaded) {
            String resource = ResourceBuilder.buildTableResource(this.projectName, this.table);
            try {
                HashMap<String, String> params = NameSpaceSchemaUtils.initParamsWithSchema(this.schemaName);
                params.put("extended", null);
                params.put("partition", this.getPartitionSpec().toString());
                PartitionMeta meta = this.client.request(PartitionMeta.class, resource.toString(), "GET", params);
                JsonObject tree = new JsonParser().parse(meta.schema).getAsJsonObject();
                if (tree.has("IsArchived")) {
                    this.isArchived = tree.get("IsArchived").getAsBoolean();
                }
                if (tree.has("IsExstore")) {
                    this.isExstore = tree.get("IsExstore").getAsBoolean();
                }
                if (tree.has("LifeCycle")) {
                    this.lifeCycle = tree.get("LifeCycle").getAsLong();
                }
                if (tree.has("PhysicalSize")) {
                    this.physicalSize = tree.get("PhysicalSize").getAsLong();
                }
                if (tree.has("FileNum")) {
                    this.fileNum = tree.get("FileNum").getAsLong();
                }
                if (tree.has("Reserved")) {
                    this.reserved = tree.get("Reserved").getAsString();
                    this.loadReservedJson(this.reserved);
                }
            }
            catch (Exception e) {
                throw new ReloadException(e.getMessage(), e);
            }
            this.isExtendInfoLoaded = true;
        }
    }

    private void loadReservedJson(String reserved) {
        JsonObject reservedJson = new JsonParser().parse(reserved).getAsJsonObject();
        this.clusterInfo = Table.parseClusterInfo(reservedJson);
    }

    @Root(name="Partition", strict=false)
    private static class PartitionMeta {
        @Element(name="Schema", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String schema;

        private PartitionMeta() {
        }
    }

    @Root(name="Partition", strict=false)
    static class PartitionSpecModel {
        @Element(name="Name", required=false)
        String partitionSpec;

        PartitionSpecModel() {
        }
    }

    @Root(name="Column", strict=false)
    static class ColumnModel {
        @Attribute(name="Name", required=false)
        protected String columnName;
        @Attribute(name="Value", required=false)
        protected String columnValue;

        ColumnModel() {
        }
    }

    @Root(name="Partition", strict=false)
    static class PartitionModel {
        @ElementList(entry="Column", inline=true, required=false)
        List<ColumnModel> columns = new ArrayList<ColumnModel>();
        @Element(name="CreationTime", required=false)
        @Convert(value=SimpleXmlUtils.EpochConverter.class)
        Date createdTime;
        @Element(name="LastDDLTime", required=false)
        @Convert(value=SimpleXmlUtils.EpochConverter.class)
        Date lastMetaModifiedTime;
        @Element(name="LastModifiedTime", required=false)
        @Convert(value=SimpleXmlUtils.EpochConverter.class)
        Date lastDataModifiedTime;
        @Element(name="LastAccessTime", required=false)
        @Convert(value=SimpleXmlUtils.EpochConverter.class)
        Date lastAccessTime;

        PartitionModel() {
        }
    }
}

