/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementMap;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Quota
extends LazyLoad {
    static final String VERSION = "wlm";
    private Odps odps;
    private QuotaModel model;

    Quota(Odps odps, String regionId, String name) {
        this.odps = odps;
        this.model = new QuotaModel();
        this.model.regionId = regionId;
        this.model.nickname = name;
    }

    Quota(Odps odps, QuotaModel model) {
        this.odps = odps;
        this.model = model;
        this.setLoaded(true);
    }

    public String getSystemInnerName() {
        this.lazyLoad();
        return this.model.name;
    }

    public Boolean isEnabled() {
        this.lazyLoad();
        return this.model.isEnabled;
    }

    public Boolean forceReservedMin() {
        this.lazyLoad();
        return this.model.properties.getOrDefault("ForceReservedMin", "false").equals("true");
    }

    public String getResourceSystemType() {
        this.lazyLoad();
        return this.model.resourceSystemType;
    }

    public String sessionServiceName() {
        this.lazyLoad();
        return this.model.sessionServiceName;
    }

    public String createTimeMs() {
        this.lazyLoad();
        return this.model.createTimeMs;
    }

    public Long getCpu() {
        this.lazyLoad();
        return this.model.cpu;
    }

    public Long getMinCpu() {
        this.lazyLoad();
        return this.model.minCpu;
    }

    public Long getElasticCpuMax() {
        this.lazyLoad();
        return this.model.elasticCpuMax;
    }

    public Long getMemory() {
        this.lazyLoad();
        return this.model.memory;
    }

    public Long getMinMemory() {
        this.lazyLoad();
        return this.model.minMemory;
    }

    public Long getElasticMemoryMax() {
        this.lazyLoad();
        return this.model.elasticMemoryMax;
    }

    public Long getGpu() {
        this.lazyLoad();
        return this.model.gpu;
    }

    public Long getMinGpu() {
        this.lazyLoad();
        return this.model.minGpu;
    }

    public Long getElasticGpuMax() {
        this.lazyLoad();
        return this.model.elasticGpuMax;
    }

    public Long getAdhocCpu() {
        this.lazyLoad();
        return this.model.adhocCpu;
    }

    public Long getAdhocMemory() {
        this.lazyLoad();
        return this.model.adhocMemory;
    }

    public Strategy getStrategy() {
        this.lazyLoad();
        return Strategy.valueOf(this.model.strategy);
    }

    public SchedulerType getSchedulerType() {
        this.lazyLoad();
        return SchedulerType.valueOf(this.model.schedulerType);
    }

    public Boolean isParentQuota() {
        this.lazyLoad();
        return this.model.isParentGroup;
    }

    public String getParentQuotaId() {
        this.lazyLoad();
        return this.model.parentId;
    }

    public Status getStatus() {
        this.lazyLoad();
        return Status.valueOf(this.model.status);
    }

    public String getNickname() {
        this.lazyLoad();
        return this.model.nickname;
    }

    public String getQuotaId() {
        this.lazyLoad();
        return this.model.id;
    }

    public String getParentNickname() {
        this.lazyLoad();
        return this.model.parentNickname;
    }

    public Double getCpuUsage() {
        this.lazyLoad();
        return this.model.cpuUsage;
    }

    public Double getAdhocCpuUsage() {
        this.lazyLoad();
        return this.model.adhocCpuUsage;
    }

    public Double getCpuReadyRatio() {
        this.lazyLoad();
        return this.model.cpuReadyRatio;
    }

    public Double getMemoryUsage() {
        this.lazyLoad();
        return this.model.memoryUsage;
    }

    public Double getAdhocMemoryUsage() {
        this.lazyLoad();
        return this.model.adhocMemoryUsage;
    }

    public Double getMemoryReadyRatio() {
        this.lazyLoad();
        return this.model.memoryReadyRatio;
    }

    public String getCreatorId() {
        this.lazyLoad();
        return this.model.creatorId;
    }

    public String getRegionId() {
        this.lazyLoad();
        return this.model.regionId;
    }

    public String getBillingPolicy() {
        this.lazyLoad();
        return this.model.billingPolicy;
    }

    public Map<String, String> getProperties() {
        this.lazyLoad();
        if (this.model.properties != null) {
            return new HashMap<String, String>(this.model.properties);
        }
        return Collections.emptyMap();
    }

    @Override
    public void reload() throws OdpsException {
        String resource = ResourceBuilder.buildQuotaResource(this.model.nickname);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("project", this.odps.getDefaultProject());
        params.put("version", VERSION);
        if (!StringUtils.isNullOrEmpty((String)this.model.regionId)) {
            params.put("region", this.model.regionId);
        }
        Response resp = this.odps.getRestClient().request(resource, "GET", params, null, null);
        try {
            this.model = SimpleXmlUtils.unmarshal(resp, QuotaModel.class);
        }
        catch (Exception e) {
            throw new OdpsException("Can't bind xml to " + QuotaModel.class, e);
        }
        this.setLoaded(true);
    }

    public static class AffinityRule
    extends HashMap<String, AffinityRuleItem> {
    }

    public static class AffinityRuleItem {
        @SerializedName(value="UserList")
        public List<String> userList;
        @SerializedName(value="ProjectList")
        public List<String> projectList;
        @SerializedName(value="PriorityRange")
        public List<Integer> priorityRange;
        @SerializedName(value="Settings")
        public Map<String, String> settings;

        public void addUser(String user) {
            if (this.userList == null) {
                this.userList = new ArrayList<String>();
            }
            this.userList.add(user);
        }

        public boolean removeUser(String user) {
            if (this.userList != null) {
                return this.userList.remove(user);
            }
            return false;
        }

        public void addProject(String project) {
            if (this.projectList == null) {
                this.projectList = new ArrayList<String>();
            }
            this.projectList.add(project);
        }

        public boolean removeProject(String project) {
            if (this.projectList != null) {
                return this.projectList.remove(project);
            }
            return false;
        }

        public void setPriorityRange(int low, int high) {
            if (this.priorityRange == null) {
                this.priorityRange = new ArrayList<Integer>(2);
            }
            this.priorityRange.clear();
            this.priorityRange.add(low);
            this.priorityRange.add(high);
        }

        public void addSetting(String key, String value) {
            if (this.settings == null) {
                this.settings = new HashMap<String, String>();
            }
            this.settings.put(key, value);
        }

        public String removeSetting(String key) {
            if (this.settings != null) {
                return this.settings.remove(key);
            }
            return null;
        }
    }

    public static class BillingPolicy {
        @SerializedName(value="billingMethod")
        public String billingMethod;
        @SerializedName(value="OdpsSpecCode")
        public String specification;
        @SerializedName(value="orderId")
        public String orderId;

        public static BillingPolicy SUBSCRIPTION(String specification) {
            BillingPolicy policy = new BillingPolicy();
            policy.billingMethod = String.valueOf((Object)BillingMethod.subscription);
            policy.specification = specification;
            return policy;
        }

        public static BillingPolicy PAYASYOUGO(String specification) {
            BillingPolicy policy = new BillingPolicy();
            policy.billingMethod = String.valueOf((Object)BillingMethod.payasyougo);
            policy.specification = specification;
            return policy;
        }

        public BillingPolicy withOrderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public boolean isSubscription() {
            return this.billingMethod.equals(String.valueOf((Object)BillingMethod.subscription));
        }

        public boolean isPayAsYouGo() {
            return this.billingMethod.equals(String.valueOf((Object)BillingMethod.payasyougo));
        }

        public String toString() {
            Gson gson = new Gson();
            return gson.toJson((Object)this);
        }

        public static enum BillingMethod {
            payasyougo,
            subscription;

        }
    }

    public static enum ResourceSystemType {
        FUXI_OFFLINE,
        FUXI_ONLINE;

    }

    public static enum Status {
        ON,
        OFF,
        INITIALIZING,
        ABNORMAL;

    }

    public static enum SchedulerType {
        Fifo,
        Fair;

    }

    public static enum Strategy {
        NoPreempt,
        Preempt;

    }

    @Root(name="Quota", strict=false)
    public static class QuotaModel {
        @Element(name="Cluster", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        public String cluster;
        @Element(name="Name", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        public String name;
        @Element(name="ID", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        public String id;
        @Element(name="IsEnabled", required=false)
        public Boolean isEnabled = true;
        @Element(name="ResourceSystemType", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        public String resourceSystemType;
        @Deprecated
        @Element(name="SessionServiceName", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        public String sessionServiceName;
        @Element(name="CreateTimeMs", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        public String createTimeMs;
        @Element(name="CPU", required=false)
        public Long cpu;
        @Element(name="MinCPU", required=false)
        public Long minCpu;
        @Element(name="ElasticCPUMax", required=false)
        public Long elasticCpuMax;
        @Element(name="ElasticCPUMin", required=false)
        public Long elasticCpuMin;
        @Element(name="AdhocCPU", required=false)
        public Long adhocCpu;
        @Element(name="Memory", required=false)
        public Long memory;
        @Element(name="MinMemory", required=false)
        public Long minMemory;
        @Element(name="ElasticMemoryMax", required=false)
        public Long elasticMemoryMax;
        @Element(name="ElasticMemoryMin", required=false)
        public Long elasticMemoryMin;
        @Element(name="AdhocMemory", required=false)
        public Long adhocMemory;
        @Element(name="AdhocGPU", required=false)
        public Long adhocGpu;
        @Element(name="Strategy", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        public String strategy;
        @Element(name="SchedulerType", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        public String schedulerType;
        @Element(name="GPU", required=false)
        public Long gpu;
        @Element(name="MinGPU", required=false)
        public Long minGpu;
        @Element(name="ElasticGPUMax", required=false)
        public Long elasticGpuMax;
        @Element(name="ElasticGPUMin", required=false)
        public Long elasticGpuMin;
        @Element(name="CPUUsage", required=false)
        public Double cpuUsage;
        @Element(name="AdhocCPUUsage", required=false)
        public Double adhocCpuUsage;
        @Element(name="MemoryUsage", required=false)
        public Double memoryUsage;
        @Element(name="AdhocMemoryUsage", required=false)
        public Double adhocMemoryUsage;
        @Element(name="CPUReadyRatio", required=false)
        public Double cpuReadyRatio;
        @Element(name="MemoryReadyRatio", required=false)
        public Double memoryReadyRatio;
        @Element(name="IsParGroup", required=false)
        public Boolean isParentGroup;
        @Element(name="ParGroupId", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        public String parentId;
        @Element(name="ParentName", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        public String parentName;
        @ElementMap(name="UserDefinedTag", required=false, entry="entry", key="key", value="value", empty=false)
        public Map<String, String> userDefinedTag = new HashMap<String, String>();
        @Element(name="VirtualClusterConfig", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        public String virtualClusterConfig;
        @Element(name="VirtualClusterDebugInfoMap", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        public String virtualClusterDebugInfoMap;
        @Element(name="TenantId", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        public String tenantId;
        @Element(name="Status", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        public String status;
        @Element(name="Nickname", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        public String nickname;
        @Element(name="ParentNickname", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        public String parentNickname;
        @Element(name="CreatorId", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        public String creatorId;
        @Element(name="Region", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        public String regionId;
        @Element(name="BillingPolicy", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        public String billingPolicy;
        @Element(name="NeedAuth", required=false)
        public Boolean needAuth;
        @Element(name="IsPureLink", required=false)
        public Boolean isPureLink;
        @Element(name="QuotaVersion", required=false)
        public Long quotaVersion;
        @Element(name="IsMetaOnly", required=false)
        public Boolean isMetaOnly;
        @Element(name="Properties", required=false)
        @Convert(value=SimpleXmlUtils.JsonMapConverter.class)
        public Map<String, String> properties;
    }
}

