/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.VolumeException;
import com.aliyun.odps.VolumeFSFile;
import com.aliyun.odps.VolumeFilter;
import com.aliyun.odps.VolumePartition;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.utils.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Volume
extends LazyLoad {
    private VolumeModel model;
    private String project;
    private String name;
    private RestClient client;

    Volume(VolumeModel model, String project, RestClient client) {
        this.model = model;
        this.name = model.name;
        this.project = project;
        this.client = client;
    }

    public Map<String, String> getProperties() {
        if (this.model.properties == null) {
            this.lazyLoad();
        }
        return this.model.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.model.properties = properties;
    }

    public String getProject() {
        return this.project;
    }

    @Override
    public void reload() throws OdpsException {
        String resource = ResourceBuilder.buildVolumeResource(this.project, this.name);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("meta", null);
        Response resp = this.client.request(resource, "GET", params, null, null);
        try {
            this.model = SimpleXmlUtils.unmarshal(resp, VolumeModel.class);
            this.model.lastModifiedTime = DateUtils.parseRfc822Date(resp.getHeader("Last_Modified"));
            this.model.createdTime = DateUtils.parseRfc822Date(resp.getHeader("x-odps-creation-time"));
            this.model.owner = resp.getHeader("x-odps-owner");
        }
        catch (Exception e) {
            throw new OdpsException("Can't bind xml to " + VolumeModel.class, e);
        }
        this.setLoaded(true);
    }

    public VolumeFSFile getVolumeFSFile(String path) throws VolumeException {
        return new VolumeFSFile(this.project, path, this.client);
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        Type type;
        if (this.model.type == null) {
            this.lazyLoad();
        }
        if (StringUtils.isBlank((String)this.model.type)) {
            return Type.OLD;
        }
        try {
            type = Type.valueOf(this.model.type.toUpperCase());
        }
        catch (Exception e) {
            type = Type.OLD;
        }
        return type;
    }

    public String getComment() {
        if (this.model.comment == null) {
            this.lazyLoad();
        }
        return this.model.comment;
    }

    public String getOwner() {
        if (this.model.owner == null) {
            this.lazyLoad();
        }
        return this.model.owner;
    }

    public Date getCreatedTime() {
        if (this.model.createdTime == null) {
            this.lazyLoad();
        }
        return this.model.createdTime;
    }

    public Date getLastModifiedTime() {
        if (this.model.lastModifiedTime == null) {
            this.lazyLoad();
        }
        return this.model.lastModifiedTime;
    }

    public long getLength() {
        if (this.model.length == null) {
            this.lazyLoad();
        }
        return this.model.length;
    }

    public Long getLifecycle() {
        if (this.model.lifecycle == null) {
            this.lazyLoad();
        }
        return this.model.lifecycle;
    }

    public void setLifecycle(long lifecycle) {
        this.model.lifecycle = lifecycle;
    }

    public int getFileCount() {
        if (this.model.fileNumber == null) {
            this.lazyLoad();
        }
        return this.model.fileNumber;
    }

    public VolumePartition getVolumePartition(String partitionName) {
        VolumePartition.VolumePartitionModel model = new VolumePartition.VolumePartitionModel();
        model.name = partitionName;
        return new VolumePartition(model, this.project, this.name, this.client);
    }

    public void deleteVolumePartition(String partitionName) throws OdpsException {
        String resource = ResourceBuilder.buildVolumePartitionResource(this.project, this.name, partitionName);
        this.client.request(resource, "DELETE", null, null, null);
    }

    public Iterator<VolumePartition> getPartitionIterator() {
        return this.getPartitionIterator(null);
    }

    public Iterator<VolumePartition> getPartitionIterator(final VolumeFilter filter) {
        return new ListIterator<VolumePartition>(){
            Map<String, String> params = new HashMap<String, String>();

            @Override
            protected List<VolumePartition> list() {
                ArrayList<VolumePartition> partitions = new ArrayList<VolumePartition>();
                this.params.put("expectmarker", "true");
                String lastMarker = this.params.get("marker");
                if (this.params.containsKey("marker") && lastMarker.length() == 0) {
                    return null;
                }
                if (filter != null && filter.getName() != null) {
                    this.params.put("name", filter.getName());
                }
                String resource = ResourceBuilder.buildVolumeResource(Volume.this.project, Volume.this.name);
                try {
                    ListPartitionsResponse resp = Volume.this.client.request(ListPartitionsResponse.class, resource, "GET", this.params);
                    for (VolumePartition.VolumePartitionModel model : ((ListPartitionsResponse)resp).partitions.partitions) {
                        VolumePartition t = new VolumePartition(model, Volume.this.project, Volume.this.name, Volume.this.client);
                        partitions.add(t);
                    }
                    this.params.put("marker", resp.marker);
                }
                catch (OdpsException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                return partitions;
            }
        };
    }

    public static boolean checkPathHasVolume(String path) {
        if (path == null || !path.startsWith("/")) {
            return false;
        }
        String[] strArray = path.split("/");
        if (strArray.length < 2) {
            return false;
        }
        return StringUtils.isNotBlank((String)strArray[1]);
    }

    @Element(name="Volume", required=false)
    private static class ListPartitionsResponse {
        @Element(name="Partitions", required=false)
        private Partitions partitions;
        @Element(name="Marker", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String marker;
        @Element(name="MaxItems", required=false)
        private Integer maxItems;

        private ListPartitionsResponse() {
        }
    }

    @Root(name="Partitions", strict=false)
    private static class Partitions {
        @ElementList(entry="Partition", inline=true, required=false)
        List<VolumePartition.VolumePartitionModel> partitions = new ArrayList<VolumePartition.VolumePartitionModel>();

        private Partitions() {
        }
    }

    @Root(name="Meta", strict=false)
    static class VolumeModel {
        @Element(name="Name", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String name;
        @Element(name="Comment", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String comment;
        @Element(name="Type", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String type;
        @Element(name="Length", required=false)
        Long length;
        @Element(name="FileNumber", required=false)
        Integer fileNumber;
        @Element(name="Owner", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String owner;
        @Element(name="Lifecycle", required=false)
        Long lifecycle;
        @Element(name="CreationTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date createdTime;
        @Element(name="LastModifiedTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date lastModifiedTime;
        @Element(name="Properties", required=false)
        @Convert(value=SimpleXmlUtils.JsonMapConverter.class)
        Map<String, String> properties;

        VolumeModel() {
        }
    }

    public static enum Type {
        NEW,
        OLD,
        EXTERNAL;

    }
}

