/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.OdpsException;
import com.aliyun.odps.tunnel.TunnelException;

public class VolumeException
extends Exception {
    private String requestId;
    private String errCode;
    private String errMsg;
    public static final String UNKNOWN_REQUEST_ID = "Unknown";
    public static final String NON_VOLUME_FS_ERROR = "NonVolumeFSError";

    public VolumeException(Throwable e) {
        super(e);
        if (e != null) {
            if (e instanceof TunnelException) {
                TunnelException te = (TunnelException)e;
                this.errCode = te.getErrorCode();
                this.errMsg = te.getErrorMsg();
                this.requestId = te.getRequestId();
            } else if (e instanceof OdpsException) {
                OdpsException oe = (OdpsException)e;
                this.errCode = oe.getErrorCode();
                this.errMsg = oe.getMessage();
                this.requestId = oe.getRequestId();
            } else {
                this.requestId = UNKNOWN_REQUEST_ID;
                this.errMsg = e.getMessage();
                this.errCode = NON_VOLUME_FS_ERROR;
            }
        }
    }

    public VolumeException(String errMsg, Throwable e) {
        this(e);
        this.errMsg = errMsg;
    }

    public VolumeException(String errCode, String errMsg) {
        this.requestId = UNKNOWN_REQUEST_ID;
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    public VolumeException(String errMsg) {
        super(errMsg);
        this.requestId = UNKNOWN_REQUEST_ID;
        this.errCode = NON_VOLUME_FS_ERROR;
        this.errMsg = errMsg;
    }

    @Override
    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        if (this.requestId != null) {
            sb.append("RequestId=").append(this.requestId);
        }
        if (this.errCode != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("ErrCode=").append(this.errCode);
        }
        if (this.errMsg != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (this.requestId != null || this.errCode != null) {
                sb.append("ErrMessage=");
            }
            sb.append(this.errMsg);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }
}

