/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.commons.proto;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.Survey;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.util.DateUtils;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.Char;
import com.aliyun.odps.data.IntervalDayTime;
import com.aliyun.odps.data.IntervalYearMonth;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordReader;
import com.aliyun.odps.data.SimpleStruct;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.data.Varchar;
import com.aliyun.odps.thirdparty.com.google.protobuf.CodedInputStream;
import com.aliyun.odps.thirdparty.com.google.protobuf.WireFormat;
import com.aliyun.odps.tunnel.TunnelTableSchema;
import com.aliyun.odps.tunnel.io.Checksum;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.type.ArrayTypeInfo;
import com.aliyun.odps.type.MapTypeInfo;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.InflaterInputStream;
import net.jpountz.lz4.LZ4FrameInputStream;
import org.xerial.snappy.SnappyFramedInputStream;

public class ProtobufRecordStreamReader
implements RecordReader {
    private BufferedInputStream bin;
    private CodedInputStream in;
    private Column[] columns;
    private TableSchema schema;
    private long count;
    private long bytesReaded = 0L;
    private Checksum crc = new Checksum();
    private Checksum crccrc = new Checksum();
    protected boolean shouldTransform = false;

    public ProtobufRecordStreamReader() {
    }

    public ProtobufRecordStreamReader(TableSchema schema, InputStream in) throws IOException {
        this(schema, null, in, new CompressOption());
    }

    public ProtobufRecordStreamReader(TableSchema schema, InputStream in, CompressOption option) throws IOException {
        this(schema, null, in, option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProtobufRecordStreamReader(List<Column> columns, InputStream in, CompressOption option) throws IOException {
        this.bin = new BufferedInputStream(in);
        if (option != null) {
            if (option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_ZLIB)) {
                this.in = CodedInputStream.newInstance(new InflaterInputStream(this.bin));
            } else if (option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_SNAPPY)) {
                this.in = CodedInputStream.newInstance((InputStream)new SnappyFramedInputStream((InputStream)this.bin));
            } else if (option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_LZ4_FRAME)) {
                this.in = CodedInputStream.newInstance((InputStream)new LZ4FrameInputStream((InputStream)this.bin));
            } else {
                if (!option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_RAW)) throw new IOException("invalid compression option.");
                this.in = CodedInputStream.newInstance(this.bin);
            }
        } else {
            this.in = CodedInputStream.newInstance(this.bin);
        }
        this.in.setSizeLimit(Integer.MAX_VALUE);
        String schemaStr = this.readSchema();
        if (StringUtils.isNullOrEmpty((String)schemaStr)) {
            throw new IOException("Invalid response schema in header:" + schemaStr);
        }
        JsonObject tree = new JsonParser().parse(schemaStr).getAsJsonObject();
        this.schema = new TunnelTableSchema(tree);
        if (columns == null) {
            this.columns = this.schema.getColumns().toArray(new Column[0]);
            return;
        } else {
            Column[] tmpColumns = new Column[columns.size()];
            for (int i = 0; i < columns.size(); ++i) {
                tmpColumns[i] = this.schema.getColumn(columns.get(i).getName());
            }
            this.columns = tmpColumns;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ProtobufRecordStreamReader(TableSchema schema, List<Column> columns, InputStream in, CompressOption option) throws IOException {
        if (columns == null) {
            this.columns = schema.getColumns().toArray(new Column[0]);
        } else {
            Column[] tmpColumns = new Column[columns.size()];
            for (int i = 0; i < columns.size(); ++i) {
                tmpColumns[i] = schema.getColumn(columns.get(i).getName());
            }
            this.columns = tmpColumns;
        }
        this.bin = new BufferedInputStream(in);
        if (option != null) {
            if (option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_ZLIB)) {
                this.in = CodedInputStream.newInstance(new InflaterInputStream(this.bin));
            } else if (option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_SNAPPY)) {
                this.in = CodedInputStream.newInstance((InputStream)new SnappyFramedInputStream((InputStream)this.bin));
            } else if (option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_LZ4_FRAME)) {
                this.in = CodedInputStream.newInstance((InputStream)new LZ4FrameInputStream((InputStream)this.bin));
            } else {
                if (!option.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_RAW)) throw new IOException("invalid compression option.");
                this.in = CodedInputStream.newInstance(this.bin);
            }
        } else {
            this.in = CodedInputStream.newInstance(this.bin);
        }
        this.in.setSizeLimit(Integer.MAX_VALUE);
    }

    public void setTransform(boolean shouldTransform) {
        this.shouldTransform = shouldTransform;
    }

    public Record read(Record reuseRecord) throws IOException {
        int checkSum;
        if (reuseRecord == null) {
            reuseRecord = new ArrayRecord(this.columns, false);
        } else {
            for (int i = 0; i < reuseRecord.getColumnCount(); ++i) {
                reuseRecord.set(i, null);
            }
        }
        while (true) {
            checkSum = 0;
            if (this.in.isAtEnd()) {
                return null;
            }
            int i = ProtobufRecordStreamReader.getTagFieldNumber(this.in);
            if (i == 33553408) {
                checkSum = (int)this.crc.getValue();
                if (this.in.readUInt32() != checkSum) {
                    throw new IOException("Checksum invalid.");
                }
                break;
            }
            if (i == 0x1FFFFFE) {
                if (this.count != this.in.readSInt64()) {
                    throw new IOException("count does not match.");
                }
                if (0x1FFFFFF != ProtobufRecordStreamReader.getTagFieldNumber(this.in)) {
                    throw new IOException("Invalid stream.");
                }
                if ((int)this.crccrc.getValue() != this.in.readUInt32()) {
                    throw new IOException("Checksum invalid.");
                }
                if (!this.in.isAtEnd()) {
                    throw new IOException("Expect at the end of stream, but not.");
                }
                return null;
            }
            if (i > this.columns.length) {
                throw new IOException("Invalid protobuf tag. Perhaps the datastream from server is crushed.");
            }
            this.crc.update(i);
            reuseRecord.set(i - 1, this.readField(this.columns[i - 1].getTypeInfo()));
        }
        this.crc.reset();
        this.crccrc.update(checkSum);
        this.bytesReaded += (long)this.in.getTotalBytesRead();
        this.in.resetSizeCounter();
        ++this.count;
        return reuseRecord;
    }

    public String readSchema() throws IOException {
        String schemaJson = "";
        while (true) {
            int checkSum = 0;
            if (this.in.isAtEnd()) {
                throw new IOException("Read schema failed, empty stream.");
            }
            int i = ProtobufRecordStreamReader.getTagFieldNumber(this.in);
            if (i == 33553920) {
                checkSum = (int)this.crc.getValue();
                if (this.in.readUInt32() != checkSum) {
                    throw new IOException("Checksum invalid.");
                }
                this.crc.reset();
                this.bytesReaded += (long)this.in.getTotalBytesRead();
                this.in.resetSizeCounter();
                return schemaJson;
            }
            if (i > 1) {
                throw new IOException("Invalid protobuf tag. Perhaps the datastream from server is crushed.");
            }
            this.crc.update(i);
            schemaJson = this.readString();
        }
    }

    private Object readField(TypeInfo type) throws IOException {
        switch (type.getOdpsType()) {
            case DOUBLE: {
                double v = this.in.readDouble();
                this.crc.update(v);
                return v;
            }
            case FLOAT: {
                float v = this.in.readFloat();
                this.crc.update(v);
                return Float.valueOf(v);
            }
            case BOOLEAN: {
                boolean v = this.in.readBool();
                this.crc.update(v);
                return v;
            }
            case BIGINT: {
                long v = this.in.readSInt64();
                this.crc.update(v);
                return v;
            }
            case INTERVAL_YEAR_MONTH: {
                long v = this.in.readSInt64();
                this.crc.update(v);
                return new IntervalYearMonth((int)v);
            }
            case INT: {
                long v = this.in.readSInt64();
                this.crc.update(v);
                return (int)v;
            }
            case SMALLINT: {
                long v = this.in.readSInt64();
                this.crc.update(v);
                return (short)v;
            }
            case TINYINT: {
                long v = this.in.readSInt64();
                this.crc.update(v);
                return (byte)v;
            }
            case STRING: {
                return this.readBytes();
            }
            case VARCHAR: {
                return new Varchar(this.readString());
            }
            case CHAR: {
                return new Char(this.readString());
            }
            case BINARY: {
                return new Binary(this.readBytes());
            }
            case DATETIME: {
                long v = this.in.readSInt64();
                this.crc.update(v);
                return this.shouldTransform ? DateUtils.ms2date(v, DateUtils.LOCAL_CAL).toInstant().atZone(ZoneId.systemDefault()) : Instant.ofEpochMilli(v).atZone(ZoneId.systemDefault());
            }
            case DATE: {
                long v = this.in.readSInt64();
                this.crc.update(v);
                return LocalDate.ofEpochDay(v);
            }
            case INTERVAL_DAY_TIME: {
                long time = this.in.readSInt64();
                int nano = this.in.readSInt32();
                this.crc.update(time);
                this.crc.update(nano);
                return new IntervalDayTime(time, nano);
            }
            case TIMESTAMP: {
                long time = this.in.readSInt64();
                int nano = this.in.readSInt32();
                this.crc.update(time);
                this.crc.update(nano);
                return Instant.ofEpochSecond(time, nano);
            }
            case DECIMAL: {
                int size = this.in.readRawVarint32();
                byte[] bytes = this.in.readRawBytes(size);
                this.crc.update(bytes, 0, bytes.length);
                BigDecimal decimal = new BigDecimal(new String(bytes, "UTF-8"));
                return decimal;
            }
            case ARRAY: {
                return this.readArray(((ArrayTypeInfo)type).getElementTypeInfo());
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)type;
                return this.readMap(mapTypeInfo.getKeyTypeInfo(), mapTypeInfo.getValueTypeInfo());
            }
            case STRUCT: {
                return this.readStruct(type);
            }
        }
        throw new IOException("Unsupported type " + type.getTypeName());
    }

    private String readString() throws IOException {
        byte[] bytes = this.readBytes();
        return new String(bytes, "utf-8");
    }

    private byte[] readBytes() throws IOException {
        int size = this.in.readRawVarint32();
        byte[] bytes = this.in.readRawBytes(size);
        this.crc.update(bytes, 0, bytes.length);
        this.bytesReaded += (long)this.in.getTotalBytesRead();
        this.in.resetSizeCounter();
        return bytes;
    }

    static int getTagFieldNumber(CodedInputStream in) throws IOException {
        return WireFormat.getTagFieldNumber(in.readTag());
    }

    @Override
    public Record read() throws IOException {
        return this.read(null);
    }

    public Record createEmptyRecord() throws IOException {
        return new ArrayRecord(this.columns);
    }

    @Override
    public void close() throws IOException {
        if (this.bin != null) {
            this.bin.close();
        }
    }

    public TableSchema getTableSchema() {
        return this.schema;
    }

    public long getTotalBytes() {
        return this.bytesReaded;
    }

    public Struct readStruct(TypeInfo type) throws IOException {
        StructTypeInfo typeInfo = (StructTypeInfo)type;
        ArrayList<Object> values = new ArrayList<Object>();
        List fieldTypeInfos = typeInfo.getFieldTypeInfos();
        for (int i = 0; i < typeInfo.getFieldCount(); ++i) {
            if (this.in.readBool()) {
                values.add(null);
                continue;
            }
            values.add(this.readField((TypeInfo)fieldTypeInfos.get(i)));
        }
        return new SimpleStruct(typeInfo, values);
    }

    public List readArray(TypeInfo type) throws IOException {
        OdpsType t = type.getOdpsType();
        int arraySize = this.in.readUInt32();
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < arraySize; ++i) {
            if (this.in.readBool()) {
                list.add(null);
                continue;
            }
            list.add(this.readField(type));
        }
        return list;
    }

    public Map readMap(TypeInfo keyType, TypeInfo valueType) throws IOException {
        List keyArray = this.readArray(keyType);
        List valueArray = this.readArray(valueType);
        if (keyArray.size() != valueArray.size()) {
            throw new IOException("Read Map error: key value does not match.");
        }
        HashMap map = new HashMap();
        for (int i = 0; i < keyArray.size(); ++i) {
            map.put(keyArray.get(i), valueArray.get(i));
        }
        return map;
    }

    @Survey
    public List readArray(OdpsType type) throws IOException {
        int arraySize = this.in.readUInt32();
        ArrayList<Object> list = null;
        switch (type) {
            case STRING: {
                list = new ArrayList<Object>();
                for (int i = 0; i < arraySize; ++i) {
                    if (this.in.readBool()) {
                        list.add(null);
                        continue;
                    }
                    int size = this.in.readRawVarint32();
                    byte[] bytes = this.in.readRawBytes(size);
                    this.crc.update(bytes, 0, bytes.length);
                    list.add(bytes);
                }
                break;
            }
            case BIGINT: {
                list = new ArrayList();
                for (int i = 0; i < arraySize; ++i) {
                    if (this.in.readBool()) {
                        list.add(null);
                        continue;
                    }
                    Long value = this.in.readSInt64();
                    this.crc.update(value);
                    list.add(value);
                }
                break;
            }
            case DOUBLE: {
                list = new ArrayList();
                for (int i = 0; i < arraySize; ++i) {
                    if (this.in.readBool()) {
                        list.add(null);
                        continue;
                    }
                    Double value = this.in.readDouble();
                    this.crc.update(value);
                    list.add(value);
                }
                break;
            }
            case BOOLEAN: {
                list = new ArrayList();
                for (int i = 0; i < arraySize; ++i) {
                    if (this.in.readBool()) {
                        list.add(null);
                        continue;
                    }
                    Boolean value = this.in.readBool();
                    this.crc.update(value);
                    list.add(value);
                }
                break;
            }
            default: {
                throw new IOException("Unsupport array type. type :" + type);
            }
        }
        return list;
    }

    @Survey
    public Map readMap(OdpsType keyType, OdpsType valueType) throws IOException {
        List keyArray = this.readArray(keyType);
        List valueArray = this.readArray(valueType);
        if (keyArray.size() != valueArray.size()) {
            throw new IOException("Read Map error: key value does not match.");
        }
        HashMap map = new HashMap();
        for (int i = 0; i < keyArray.size(); ++i) {
            map.put(keyArray.get(i), valueArray.get(i));
        }
        return map;
    }
}

