/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ml;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.ml.ModelAbTestInfo;
import com.aliyun.odps.ml.ModelResource;
import com.aliyun.odps.ml.ModelResourceBuilder;
import com.aliyun.odps.ml.OnlineModelInfo;
import com.aliyun.odps.ml.OnlineModelInfoNew;
import com.aliyun.odps.ml.OnlineStatus;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.google.gson.GsonBuilder;
import java.util.Date;
import java.util.HashMap;

public class OnlineModel
extends LazyLoad {
    private OnlineModelDesc modelDesc;
    private RestClient client;

    OnlineModel(OnlineModelDesc desc, RestClient client) {
        this.modelDesc = desc;
        this.client = client;
    }

    public String getName() {
        return this.modelDesc.modelName;
    }

    @Deprecated
    public String getComment() {
        return null;
    }

    public String getOwner() {
        if (this.modelDesc.owner == null && this.client != null) {
            this.lazyLoad();
        }
        return this.modelDesc.owner;
    }

    public Date getCreatedTime() {
        if (this.modelDesc.createTime == null && this.client != null) {
            this.lazyLoad();
        }
        return this.modelDesc.createTime;
    }

    public Date getLastModifiedTime() {
        if (this.modelDesc.lastModifiedTime == null && this.client != null) {
            this.lazyLoad();
        }
        return this.modelDesc.lastModifiedTime;
    }

    public String getProject() {
        return this.modelDesc.project;
    }

    public String getOfflineModelProject() {
        this.lazyLoad();
        return this.modelDesc.offlinemodelProject;
    }

    public String getOfflineModelName() {
        this.lazyLoad();
        return this.modelDesc.offlinemodelName;
    }

    public String getOfflineModelId() {
        this.lazyLoad();
        return this.modelDesc.offlinemodelId;
    }

    public long getInstanceNum() {
        this.lazyLoad();
        return this.modelDesc.instanceNum;
    }

    public OnlineStatus getStatus() {
        this.lazyLoad();
        return OnlineStatus.valueOf(this.modelDesc.status.toUpperCase());
    }

    public ModelResource getUsedResource() {
        if (this.modelDesc.usedRes == null && this.client != null) {
            this.lazyLoad();
        }
        return (ModelResource)new GsonBuilder().disableHtmlEscaping().create().fromJson(this.modelDesc.usedRes, ModelResource.class);
    }

    public ModelResource getApplyResource() {
        if (this.modelDesc.applyRes == null && this.client != null) {
            this.lazyLoad();
        }
        return (ModelResource)new GsonBuilder().disableHtmlEscaping().create().fromJson(this.modelDesc.applyRes, ModelResource.class);
    }

    public String getVersion() {
        if (this.modelDesc.version == null && this.client != null) {
            this.lazyLoad();
        }
        return this.modelDesc.version;
    }

    @Deprecated
    public long getApplyQPS() {
        this.lazyLoad();
        return this.modelDesc.applyQos;
    }

    public long getApplyQOS() {
        this.lazyLoad();
        return this.modelDesc.applyQos;
    }

    public String getServiceTag() {
        this.lazyLoad();
        return this.modelDesc.serviceTag;
    }

    public String getServiceName() {
        this.lazyLoad();
        return this.modelDesc.serviceName;
    }

    public String getFaliedMsg() {
        if (this.modelDesc.lastFailMsg == null && this.client != null) {
            this.lazyLoad();
        }
        return this.modelDesc.lastFailMsg;
    }

    public String getABTest() {
        this.lazyLoad();
        return this.modelDesc.ABTest;
    }

    public String getPredictDesc() {
        this.lazyLoad();
        return this.modelDesc.predictDesc;
    }

    public String getRuntime() {
        this.lazyLoad();
        return this.modelDesc.runtime;
    }

    public void updateQos(short qos) throws OdpsException {
        this.update(this.modelDesc.offlinemodelProject, this.modelDesc.offlinemodelName, qos, this.modelDesc.instanceNum);
    }

    public void updateInstanceNumber(short instanceNum) throws OdpsException {
        this.update(this.modelDesc.offlinemodelProject, this.modelDesc.offlinemodelName, this.modelDesc.applyQos, instanceNum);
    }

    public void update(String offlinemodelProject, String offlinemodelName) throws OdpsException {
        this.update(offlinemodelProject, offlinemodelName, this.modelDesc.applyQos, this.modelDesc.instanceNum);
    }

    public void update(String offlinemodelProject, String offlinemodelName, short qos, short instanceNum) throws OdpsException {
        if (offlinemodelProject == null || offlinemodelProject.equals("")) {
            throw new IllegalArgumentException("offlinemodelProject required.");
        }
        if (offlinemodelName == null || offlinemodelName.equals("")) {
            throw new IllegalArgumentException("offlinemodelName required.");
        }
        OnlineModelInfo modelInfo = new OnlineModelInfo();
        modelInfo.offlineModelName = offlinemodelName;
        modelInfo.offlineProject = offlinemodelProject;
        modelInfo.QOS = qos;
        modelInfo.instanceNum = instanceNum;
        this.updateInternally(modelInfo);
    }

    public void update(OnlineModelInfo modelInfo) throws OdpsException {
        this.updateInternally(modelInfo);
    }

    public void update(OnlineModelInfoNew modelInfo) throws OdpsException {
        this.updateInternally(modelInfo);
    }

    public void update(ModelAbTestInfo abTestInfo) throws OdpsException {
        String xml = null;
        try {
            xml = SimpleXmlUtils.marshal(abTestInfo);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        String resource = ModelResourceBuilder.buildOnlineModelResource(this.modelDesc.project, this.modelDesc.modelName);
        this.client.stringRequest(resource, "PUT", null, headers, xml);
    }

    @Override
    public void reload() throws OdpsException {
        String resource = ModelResourceBuilder.buildOnlineModelResource(this.modelDesc.project, this.modelDesc.modelName);
        this.modelDesc = this.client.request(OnlineModelDesc.class, resource, "GET");
    }

    private void updateInternally(OnlineModelInfo modelInfo) throws OdpsException {
        String xml = null;
        try {
            xml = SimpleXmlUtils.marshal(modelInfo);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        String resource = ModelResourceBuilder.buildOnlineModelResource(this.modelDesc.project, this.modelDesc.modelName);
        this.client.stringRequest(resource, "PUT", null, headers, xml);
        this.modelDesc.offlinemodelName = modelInfo.offlineModelName;
        this.modelDesc.offlinemodelProject = modelInfo.offlineProject;
        this.modelDesc.applyQos = modelInfo.QOS;
        this.modelDesc.instanceNum = modelInfo.instanceNum;
    }

    private void updateInternally(OnlineModelInfoNew modelInfo) throws OdpsException {
        String xml = null;
        try {
            xml = SimpleXmlUtils.marshal(modelInfo);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        String resource = ModelResourceBuilder.buildOnlineModelResource(this.modelDesc.project, this.modelDesc.modelName);
        this.client.stringRequest(resource, "PUT", null, headers, xml);
        this.modelDesc.applyQos = modelInfo.QOS;
        this.modelDesc.instanceNum = modelInfo.instanceNum;
    }

    @Root(name="Onlinemodel", strict=false)
    static class OnlineModelDesc {
        @Element(name="Project", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String project;
        @Element(name="Name", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String modelName;
        @Element(name="Version", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String version;
        @Element(name="Owner", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String owner;
        @Element(name="CreateTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date createTime;
        @Element(name="LastModifiedTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date lastModifiedTime;
        @Element(name="OfflinemodelProject", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String offlinemodelProject;
        @Element(name="OfflinemodelName", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String offlinemodelName;
        @Element(name="OfflinemodelId", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String offlinemodelId;
        @Element(name="ApplyRes", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String applyRes;
        @Element(name="UsedRes", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String usedRes;
        @Element(name="QOS", required=false)
        short applyQos;
        @Element(name="InstanceNum", required=false)
        short instanceNum;
        @Element(name="Status", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String status;
        @Element(name="ServiceTag", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String serviceTag;
        @Element(name="ServiceName", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String serviceName;
        @Element(name="LastFailMsg", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String lastFailMsg;
        @Element(name="PredictDesc", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String predictDesc;
        @Element(name="ABTest", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String ABTest;
        @Element(name="Runtime", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String runtime;

        OnlineModelDesc() {
        }
    }
}

