/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.simpleframework.xml.core;

import com.aliyun.odps.simpleframework.xml.DefaultType;
import com.aliyun.odps.simpleframework.xml.Order;
import com.aliyun.odps.simpleframework.xml.Version;
import com.aliyun.odps.simpleframework.xml.core.Caller;
import com.aliyun.odps.simpleframework.xml.core.ClassScanner;
import com.aliyun.odps.simpleframework.xml.core.Contact;
import com.aliyun.odps.simpleframework.xml.core.ContactList;
import com.aliyun.odps.simpleframework.xml.core.Context;
import com.aliyun.odps.simpleframework.xml.core.Decorator;
import com.aliyun.odps.simpleframework.xml.core.Detail;
import com.aliyun.odps.simpleframework.xml.core.Function;
import com.aliyun.odps.simpleframework.xml.core.Instantiator;
import com.aliyun.odps.simpleframework.xml.core.Label;
import com.aliyun.odps.simpleframework.xml.core.ParameterMap;
import com.aliyun.odps.simpleframework.xml.core.Scanner;
import com.aliyun.odps.simpleframework.xml.core.Section;
import com.aliyun.odps.simpleframework.xml.core.Signature;
import com.aliyun.odps.simpleframework.xml.core.Structure;
import com.aliyun.odps.simpleframework.xml.core.StructureBuilder;
import com.aliyun.odps.simpleframework.xml.core.Support;
import java.lang.annotation.Annotation;
import java.util.List;

class ObjectScanner
implements Scanner {
    private StructureBuilder builder;
    private ClassScanner scanner;
    private Structure structure;
    private Support support;
    private Detail detail;

    public ObjectScanner(Detail detail, Support support) throws Exception {
        this.scanner = new ClassScanner(detail, support);
        this.builder = new StructureBuilder(this, detail, support);
        this.support = support;
        this.detail = detail;
        this.scan(detail);
    }

    @Override
    public Signature getSignature() {
        return this.scanner.getSignature();
    }

    @Override
    public List<Signature> getSignatures() {
        return this.scanner.getSignatures();
    }

    @Override
    public ParameterMap getParameters() {
        return this.scanner.getParameters();
    }

    @Override
    public Instantiator getInstantiator() {
        return this.structure.getInstantiator();
    }

    @Override
    public Class getType() {
        return this.detail.getType();
    }

    @Override
    public Decorator getDecorator() {
        return this.scanner.getDecorator();
    }

    @Override
    public Caller getCaller(Context context) {
        return new Caller(this, context);
    }

    @Override
    public Section getSection() {
        return this.structure.getSection();
    }

    @Override
    public Version getRevision() {
        return this.structure.getRevision();
    }

    @Override
    public Order getOrder() {
        return this.scanner.getOrder();
    }

    @Override
    public Label getVersion() {
        return this.structure.getVersion();
    }

    @Override
    public Label getText() {
        return this.structure.getText();
    }

    @Override
    public String getName() {
        return this.detail.getName();
    }

    @Override
    public Function getCommit() {
        return this.scanner.getCommit();
    }

    @Override
    public Function getValidate() {
        return this.scanner.getValidate();
    }

    @Override
    public Function getPersist() {
        return this.scanner.getPersist();
    }

    @Override
    public Function getComplete() {
        return this.scanner.getComplete();
    }

    @Override
    public Function getReplace() {
        return this.scanner.getReplace();
    }

    @Override
    public Function getResolve() {
        return this.scanner.getResolve();
    }

    @Override
    public boolean isPrimitive() {
        return this.structure.isPrimitive();
    }

    @Override
    public boolean isEmpty() {
        return this.scanner.getRoot() == null;
    }

    @Override
    public boolean isStrict() {
        return this.detail.isStrict();
    }

    private void scan(Detail detail) throws Exception {
        this.order(detail);
        this.field(detail);
        this.method(detail);
        this.validate(detail);
        this.commit(detail);
    }

    private void order(Detail detail) throws Exception {
        Class type = detail.getType();
        this.builder.assemble(type);
    }

    private void commit(Detail detail) throws Exception {
        Class type = detail.getType();
        if (this.structure == null) {
            this.structure = this.builder.build(type);
        }
        this.builder = null;
    }

    private void validate(Detail detail) throws Exception {
        Class type = detail.getType();
        this.builder.commit(type);
        this.builder.validate(type);
    }

    private void field(Detail detail) throws Exception {
        Class type = detail.getType();
        DefaultType access = detail.getOverride();
        ContactList list = this.support.getFields(type, access);
        for (Contact contact : list) {
            Annotation label = contact.getAnnotation();
            if (label == null) continue;
            this.builder.process(contact, label);
        }
    }

    private void method(Detail detail) throws Exception {
        Class type = detail.getType();
        DefaultType access = detail.getOverride();
        ContactList list = this.support.getMethods(type, access);
        for (Contact contact : list) {
            Annotation label = contact.getAnnotation();
            if (label == null) continue;
            this.builder.process(contact, label);
        }
    }
}

