/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.simpleframework.xml.core;

import com.aliyun.odps.simpleframework.xml.Attribute;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementArray;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.ElementListUnion;
import com.aliyun.odps.simpleframework.xml.ElementMap;
import com.aliyun.odps.simpleframework.xml.ElementMapUnion;
import com.aliyun.odps.simpleframework.xml.ElementUnion;
import com.aliyun.odps.simpleframework.xml.Text;
import com.aliyun.odps.simpleframework.xml.core.AttributeParameter;
import com.aliyun.odps.simpleframework.xml.core.ElementArrayParameter;
import com.aliyun.odps.simpleframework.xml.core.ElementListParameter;
import com.aliyun.odps.simpleframework.xml.core.ElementListUnionParameter;
import com.aliyun.odps.simpleframework.xml.core.ElementMapParameter;
import com.aliyun.odps.simpleframework.xml.core.ElementMapUnionParameter;
import com.aliyun.odps.simpleframework.xml.core.ElementParameter;
import com.aliyun.odps.simpleframework.xml.core.ElementUnionParameter;
import com.aliyun.odps.simpleframework.xml.core.Parameter;
import com.aliyun.odps.simpleframework.xml.core.PersistenceException;
import com.aliyun.odps.simpleframework.xml.core.Support;
import com.aliyun.odps.simpleframework.xml.core.TextParameter;
import com.aliyun.odps.simpleframework.xml.stream.Format;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;

class ParameterFactory {
    private final Format format;

    public ParameterFactory(Support support) {
        this.format = support.getFormat();
    }

    public Parameter getInstance(Constructor factory, Annotation label, int index) throws Exception {
        return this.getInstance(factory, label, null, index);
    }

    public Parameter getInstance(Constructor factory, Annotation label, Annotation entry, int index) throws Exception {
        Constructor builder = this.getConstructor(label);
        if (entry != null) {
            return (Parameter)builder.newInstance(factory, label, entry, this.format, index);
        }
        return (Parameter)builder.newInstance(factory, label, this.format, index);
    }

    private Constructor getConstructor(Annotation label) throws Exception {
        ParameterBuilder builder = this.getBuilder(label);
        Constructor factory = builder.getConstructor();
        if (!factory.isAccessible()) {
            factory.setAccessible(true);
        }
        return factory;
    }

    private ParameterBuilder getBuilder(Annotation label) throws Exception {
        if (label instanceof Element) {
            return new ParameterBuilder(ElementParameter.class, Element.class);
        }
        if (label instanceof ElementList) {
            return new ParameterBuilder(ElementListParameter.class, ElementList.class);
        }
        if (label instanceof ElementArray) {
            return new ParameterBuilder(ElementArrayParameter.class, ElementArray.class);
        }
        if (label instanceof ElementMapUnion) {
            return new ParameterBuilder(ElementMapUnionParameter.class, ElementMapUnion.class, ElementMap.class);
        }
        if (label instanceof ElementListUnion) {
            return new ParameterBuilder(ElementListUnionParameter.class, ElementListUnion.class, ElementList.class);
        }
        if (label instanceof ElementUnion) {
            return new ParameterBuilder(ElementUnionParameter.class, ElementUnion.class, Element.class);
        }
        if (label instanceof ElementMap) {
            return new ParameterBuilder(ElementMapParameter.class, ElementMap.class);
        }
        if (label instanceof Attribute) {
            return new ParameterBuilder(AttributeParameter.class, Attribute.class);
        }
        if (label instanceof Text) {
            return new ParameterBuilder(TextParameter.class, Text.class);
        }
        throw new PersistenceException("Annotation %s not supported", label);
    }

    private static class ParameterBuilder {
        private final Class entry;
        private final Class label;
        private final Class type;

        public ParameterBuilder(Class type, Class label) {
            this(type, label, null);
        }

        public ParameterBuilder(Class type, Class label, Class entry) {
            this.label = label;
            this.entry = entry;
            this.type = type;
        }

        public Constructor getConstructor() throws Exception {
            if (this.entry != null) {
                return this.getConstructor(this.label, this.entry);
            }
            return this.getConstructor(this.label);
        }

        public Constructor getConstructor(Class label) throws Exception {
            return this.getConstructor(Constructor.class, label, Format.class, Integer.TYPE);
        }

        public Constructor getConstructor(Class label, Class entry) throws Exception {
            return this.getConstructor(Constructor.class, label, entry, Format.class, Integer.TYPE);
        }

        private Constructor getConstructor(Class ... types) throws Exception {
            return this.type.getConstructor(types);
        }
    }
}

