/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa.commandapi;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.security.SecurityManager;
import com.aliyun.odps.sqa.commandapi.Command;
import com.aliyun.odps.sqa.commandapi.CommandInfo;
import com.aliyun.odps.sqa.commandapi.RecordIter;
import com.aliyun.odps.sqa.commandapi.utils.CommandUtil;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

class AuthorizationCommand
implements Command {
    AuthorizationCommand() {
    }

    @Override
    public boolean isSync() {
        return true;
    }

    @Override
    public List<TypeInfo> getResultTypes() {
        return Collections.singletonList(TypeInfoFactory.STRING);
    }

    @Override
    public List<String> getResultHeaders() {
        return Collections.singletonList("Info");
    }

    @Override
    public RecordIter<Record> run(Odps odps, CommandInfo commandInfo) throws OdpsException {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("odps.namespace.schema", String.valueOf(commandInfo.isOdpsNamespaceSchema()));
        if (commandInfo.getHint().containsKey("odps.sql.allow.namespace.schema")) {
            settings.put("odps.sql.allow.namespace.schema", String.valueOf(commandInfo.isOdpsNamespaceSchema()));
        }
        settings.put("odps.default.schema", odps.getCurrentSchema());
        SecurityManager sm = odps.projects().get().getSecurityManager();
        SecurityManager.AuthorizationQueryInstance instance = sm.run(commandInfo.getCommandText(), false, null, settings);
        instance.waitForSuccess();
        String result = instance.getResult();
        return new RecordIter<Record>(CommandUtil.toRecord(result, this.getResultHeaders().get(0)).iterator(), this.getResultHeaders(), this.getResultTypes());
    }
}

