/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa.commandapi;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Project;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.sqa.commandapi.Command;
import com.aliyun.odps.sqa.commandapi.CommandInfo;
import com.aliyun.odps.sqa.commandapi.RecordIter;
import com.aliyun.odps.sqa.commandapi.utils.CommandUtil;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class DescribeProjectCommand
implements Command {
    private static final Map<String, TypeInfo> projectMap = new LinkedHashMap<String, TypeInfo>();
    private static final Map<String, TypeInfo> projectExtendedMap;
    private String projectName;
    private boolean extended = false;

    public DescribeProjectCommand(String projectName, boolean extended) {
        this.projectName = projectName;
        this.extended = extended;
    }

    @Override
    public boolean isSync() {
        return true;
    }

    @Override
    public List<String> getResultHeaders() {
        return new ArrayList<String>(this.getResultTypeInfo().keySet());
    }

    @Override
    public List<TypeInfo> getResultTypes() {
        return new ArrayList<TypeInfo>(this.getResultTypeInfo().values());
    }

    private Map<String, TypeInfo> getResultTypeInfo() {
        if (this.extended) {
            return projectExtendedMap;
        }
        return projectMap;
    }

    @Override
    public RecordIter<Record> run(Odps odps, CommandInfo commandInfo) throws OdpsException {
        Project prj = odps.projects().get(this.projectName);
        prj.reload();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", prj.getName());
        map.put("Comment", prj.getComment());
        map.put("Type", prj.getType().toString());
        map.put("Owner", prj.getOwner());
        map.put("CreatedTime", prj.getCreatedTime());
        map.put("Properties", prj.getProperties());
        if (this.extended) {
            map.put("ExtendedProperties", prj.getExtendedProperties());
        }
        return new RecordIter<Record>(CommandUtil.toRecord(map, this.getResultTypeInfo()).iterator(), this.getResultHeaders(), this.getResultTypes());
    }

    static {
        projectMap.put("Name", (TypeInfo)TypeInfoFactory.STRING);
        projectMap.put("Comment", (TypeInfo)TypeInfoFactory.STRING);
        projectMap.put("Type", (TypeInfo)TypeInfoFactory.STRING);
        projectMap.put("Owner", (TypeInfo)TypeInfoFactory.STRING);
        projectMap.put("CreatedTime", (TypeInfo)TypeInfoFactory.DATETIME);
        projectMap.put("Properties", (TypeInfo)TypeInfoFactory.getMapTypeInfo((TypeInfo)TypeInfoFactory.STRING, (TypeInfo)TypeInfoFactory.STRING));
        projectExtendedMap = new LinkedHashMap<String, TypeInfo>(projectMap);
        projectExtendedMap.put("ExtendedProperties", (TypeInfo)TypeInfoFactory.getMapTypeInfo((TypeInfo)TypeInfoFactory.STRING, (TypeInfo)TypeInfoFactory.STRING));
    }
}

