/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa.commandapi;

import com.aliyun.odps.Column;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Partition;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.Table;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.SimpleStruct;
import com.aliyun.odps.sqa.commandapi.Command;
import com.aliyun.odps.sqa.commandapi.CommandInfo;
import com.aliyun.odps.sqa.commandapi.RecordIter;
import com.aliyun.odps.sqa.commandapi.utils.CommandUtil;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

class DescribeTableCommand
implements Command {
    private static final Map<String, TypeInfo> tableMap = new LinkedHashMap<String, TypeInfo>();
    private static final Map<String, TypeInfo> partitionMap;
    private static final Map<String, TypeInfo> extendedTableMap;
    private static final Map<String, TypeInfo> extendedPartitionMap;
    private String project;
    private String schema;
    private String table;
    private String partition;
    private boolean isExtended;

    public DescribeTableCommand(String project, String schema, String table, String partition, boolean isExtended) {
        this.project = project;
        this.schema = schema;
        this.table = table;
        this.partition = partition;
        this.isExtended = isExtended;
    }

    @Override
    public boolean isSync() {
        return true;
    }

    private Map<String, TypeInfo> getResultTypeInfo() {
        if (this.partition == null) {
            return this.isExtended ? extendedTableMap : tableMap;
        }
        return this.isExtended ? extendedPartitionMap : partitionMap;
    }

    @Override
    public List<TypeInfo> getResultTypes() {
        return new ArrayList<TypeInfo>(this.getResultTypeInfo().values());
    }

    @Override
    public List<String> getResultHeaders() {
        return new ArrayList<String>(this.getResultTypeInfo().keySet());
    }

    static StructTypeInfo getStructTypeInfo() {
        ArrayList names = Lists.newArrayList((Object[])new String[]{"Field", "Type", "Comment"});
        StructTypeInfo structTypeInfo = TypeInfoFactory.getStructTypeInfo((List)names, (List)Lists.newArrayList((Object[])new TypeInfo[]{TypeInfoFactory.STRING, TypeInfoFactory.STRING, TypeInfoFactory.STRING}));
        return structTypeInfo;
    }

    static StructTypeInfo getExtendedStructTypeInfo() {
        ArrayList extendedNames = Lists.newArrayList((Object[])new String[]{"Field", "Type", "Nullable", "DefaultValue", "Comment"});
        StructTypeInfo extendedStructTypeInfo = TypeInfoFactory.getStructTypeInfo((List)extendedNames, (List)Lists.newArrayList((Object[])new TypeInfo[]{TypeInfoFactory.STRING, TypeInfoFactory.STRING, TypeInfoFactory.BOOLEAN, TypeInfoFactory.STRING, TypeInfoFactory.STRING}));
        return extendedStructTypeInfo;
    }

    @Override
    public RecordIter<Record> run(Odps odps, CommandInfo commandInfo) throws OdpsException {
        Map<String, Object> results;
        boolean useOdpsNamespaceSchema = commandInfo.isOdpsNamespaceSchema();
        String schemaCopy = this.schema;
        this.schema = CommandUtil.getRealSchemaName(odps, this.project, this.schema, useOdpsNamespaceSchema);
        this.project = CommandUtil.getRealProjectName(odps, this.project, schemaCopy, useOdpsNamespaceSchema);
        Table t = odps.tables().get(this.project, this.schema, this.table);
        if (this.partition == null) {
            t.reload();
            results = this.isExtended ? this.getExtendedRows(t, null) : this.getRows(t, null);
        } else {
            if (this.partition.trim().length() == 0) {
                throw new OdpsException("Invalid partition key.");
            }
            Partition pt = t.getPartition(new PartitionSpec(this.partition));
            pt.reload();
            results = this.isExtended ? this.getExtendedRows(t, pt) : this.getRows(t, pt);
        }
        return new RecordIter<Record>(CommandUtil.toRecord(results, this.getResultTypeInfo()).iterator(), this.getResultHeaders(), this.getResultTypes());
    }

    private Map<String, Object> getRows(Table t, Partition meta) {
        return this.getRows(t, meta, false);
    }

    private Map<String, Object> getRows(Table t, Partition meta, boolean isExtended) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (meta != null) {
                map.put("PartitionSize", meta.getSize());
                map.put("CreatedTime", meta.getCreatedTime());
                map.put("LastDDLTime", meta.getLastMetaModifiedTime());
                map.put("LastModifiedTime", meta.getLastDataModifiedTime());
            } else {
                map.put("Owner", t.getOwner());
                map.put("Project", t.getProject());
                map.put("Schema", t.getSchemaName());
                map.put("TableComment", t.getComment());
                map.put("CreatedTime", t.getCreatedTime());
                map.put("LastDDLTime", t.getLastMetaModifiedTime());
                map.put("LastModifiedTime", t.getLastDataModifiedTime());
                map.put("Lifecycle", t.getLife());
                if (t.isExternalTable()) {
                    map.put("TableType", Table.TableType.EXTERNAL_TABLE.toString());
                } else if (t.isVirtualView()) {
                    map.put("TableType", Table.TableType.VIRTUAL_VIEW.toString());
                } else if (t.isMaterializedView()) {
                    map.put("TableType", Table.TableType.MATERIALIZED_VIEW.toString());
                } else {
                    map.put("TableType", Table.TableType.MANAGED_TABLE.toString());
                }
                ArrayList<SimpleStruct> structList = new ArrayList<SimpleStruct>();
                for (Column c : t.getSchema().getColumns()) {
                    String fieldName = c.getName();
                    String typeName = c.getTypeInfo().getTypeName().toLowerCase();
                    String comment = c.getComment();
                    if (isExtended) {
                        String defaultValueStr = null;
                        if (c.hasDefaultValue()) {
                            defaultValueStr = c.getDefaultValue();
                        }
                        SimpleStruct struct = new SimpleStruct(DescribeTableCommand.getExtendedStructTypeInfo(), (List)Lists.newArrayList((Object[])new Object[]{fieldName, typeName, c.isNullable(), defaultValueStr, comment}));
                        structList.add(struct);
                        continue;
                    }
                    SimpleStruct struct = new SimpleStruct(DescribeTableCommand.getStructTypeInfo(), (List)Lists.newArrayList((Object[])new Object[]{fieldName, typeName, comment}));
                    structList.add(struct);
                }
                map.put("NativeColumns", structList);
                map.put("PartitionColumns", null);
                if (t.getSchema().getPartitionColumns().size() > 0) {
                    ArrayList<SimpleStruct> partitionStruct = new ArrayList<SimpleStruct>();
                    for (Column c : t.getSchema().getPartitionColumns()) {
                        SimpleStruct struct = new SimpleStruct(DescribeTableCommand.getStructTypeInfo(), (List)Lists.newArrayList((Object[])new Object[]{c.getName(), c.getTypeInfo().getTypeName().toLowerCase(), c.getComment()}));
                        partitionStruct.add(struct);
                    }
                    map.put("PartitionColumns", partitionStruct);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid table schema.", e);
        }
        return map;
    }

    private Map<String, Object> getExtendedRows(Table t, Partition pt) {
        Map<String, Object> results = this.getRows(t, pt, true);
        if (t.isVirtualView()) {
            return results;
        }
        try {
            if (pt != null) {
                results.put("LifeCycle", pt.getLifeCycle());
                results.put("IsExstore", pt.isExstore());
                results.put("IsArchived", pt.isArchived());
                results.put("PhysicalSize", pt.getPhysicalSize());
                results.put("FileNum", pt.getFileNum());
            } else {
                LinkedHashMap<String, String> extendedInfo = new LinkedHashMap<String, String>();
                if (t.isExternalTable()) {
                    extendedInfo.put("TableID", t.getTableID());
                    extendedInfo.put("StorageHandler", t.getStorageHandler());
                    extendedInfo.put("Location", t.getLocation());
                    extendedInfo.put("Resources", t.getResources());
                    if (t.getSerDeProperties() != null) {
                        for (Map.Entry<String, String> entry : t.getSerDeProperties().entrySet()) {
                            extendedInfo.put(entry.getKey(), StringEscapeUtils.escapeJava((String)entry.getValue()));
                        }
                    }
                } else if (!t.isVirtualView()) {
                    if (t.isMaterializedView()) {
                        extendedInfo.put("IsOutdated", String.valueOf(t.isMaterializedViewOutdated()));
                    }
                    extendedInfo.put("TableID", t.getTableID());
                    extendedInfo.put("IsArchived", String.valueOf(t.isArchived()));
                    extendedInfo.put("PhysicalSize", String.valueOf(t.getPhysicalSize()));
                    extendedInfo.put("FileNum", String.valueOf(t.getFileNum()));
                }
                extendedInfo.put("CryptoAlgoName", t.getCryptoAlgoName());
                results.put("ExtendedInfo", extendedInfo);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid table schema.", e);
        }
        return results;
    }

    static {
        tableMap.put("Owner", (TypeInfo)TypeInfoFactory.STRING);
        tableMap.put("Project", (TypeInfo)TypeInfoFactory.STRING);
        tableMap.put("Schema", (TypeInfo)TypeInfoFactory.STRING);
        tableMap.put("TableComment", (TypeInfo)TypeInfoFactory.STRING);
        tableMap.put("CreatedTime", (TypeInfo)TypeInfoFactory.DATETIME);
        tableMap.put("LastDDLTime", (TypeInfo)TypeInfoFactory.DATETIME);
        tableMap.put("LastModifiedTime", (TypeInfo)TypeInfoFactory.DATETIME);
        tableMap.put("Lifecycle", (TypeInfo)TypeInfoFactory.BIGINT);
        tableMap.put("TableType", (TypeInfo)TypeInfoFactory.STRING);
        tableMap.put("NativeColumns", (TypeInfo)TypeInfoFactory.getArrayTypeInfo((TypeInfo)DescribeTableCommand.getStructTypeInfo()));
        tableMap.put("PartitionColumns", (TypeInfo)TypeInfoFactory.getArrayTypeInfo((TypeInfo)DescribeTableCommand.getStructTypeInfo()));
        partitionMap = new LinkedHashMap<String, TypeInfo>();
        partitionMap.put("PartitionSize", (TypeInfo)TypeInfoFactory.BIGINT);
        partitionMap.put("CreatedTime", (TypeInfo)TypeInfoFactory.DATETIME);
        partitionMap.put("LastDDLTime", (TypeInfo)TypeInfoFactory.DATETIME);
        partitionMap.put("LastModifiedTime", (TypeInfo)TypeInfoFactory.DATETIME);
        extendedTableMap = new LinkedHashMap<String, TypeInfo>(tableMap);
        extendedTableMap.put("ExtendedInfo", (TypeInfo)TypeInfoFactory.getMapTypeInfo((TypeInfo)TypeInfoFactory.STRING, (TypeInfo)TypeInfoFactory.STRING));
        extendedPartitionMap = new LinkedHashMap<String, TypeInfo>(partitionMap);
        extendedPartitionMap.put("LifeCycle", (TypeInfo)TypeInfoFactory.BIGINT);
        extendedPartitionMap.put("IsExstore", (TypeInfo)TypeInfoFactory.BOOLEAN);
        extendedPartitionMap.put("IsArchived", (TypeInfo)TypeInfoFactory.BOOLEAN);
        extendedPartitionMap.put("PhysicalSize", (TypeInfo)TypeInfoFactory.BIGINT);
        extendedPartitionMap.put("FileNum", (TypeInfo)TypeInfoFactory.BIGINT);
    }
}

