/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa.commandapi;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.sqa.commandapi.Command;
import com.aliyun.odps.sqa.commandapi.CommandInfo;
import com.aliyun.odps.sqa.commandapi.RecordIter;
import com.aliyun.odps.sqa.commandapi.utils.CommandUtil;
import com.aliyun.odps.task.SQLCostTask;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class SQLCostCommand
implements Command {
    private String query;
    private String instanceId = "";

    public SQLCostCommand(String query) {
        this.query = query;
    }

    @Override
    public boolean isSync() {
        return false;
    }

    @Override
    public List<String> getResultHeaders() {
        return Collections.singletonList("Info");
    }

    @Override
    public List<TypeInfo> getResultTypes() {
        return Collections.singletonList(TypeInfoFactory.STRING);
    }

    @Override
    public RecordIter<Record> run(Odps odps, CommandInfo commandInfo) throws OdpsException {
        String taskName = "sql_cost_command_task_" + Calendar.getInstance().getTimeInMillis();
        SQLCostTask task = new SQLCostTask();
        task.setName(taskName);
        task.setQuery(this.query + ";");
        Map<String, String> settings = commandInfo.getHint();
        for (Map.Entry<String, String> property : settings.entrySet()) {
            task.setProperty(property.getKey(), property.getValue());
        }
        this.instanceId = CommandUtil.runJob(task, odps);
        Instance instance = odps.instances().get(this.instanceId);
        commandInfo.setTaskName(taskName);
        commandInfo.setInstance(instance, odps.logview().generateLogView(instance, 168L), null);
        return null;
    }
}

