/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.GeneralConfiguration;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.utils.StringUtils;
import java.net.URI;
import java.net.URISyntaxException;

public class Configuration
extends GeneralConfiguration {
    private CompressOption option = new CompressOption();
    private String quotaName = "";

    public Configuration(Odps odps) {
        super(odps);
    }

    public CompressOption getCompressOption() {
        return this.option;
    }

    public void setCompressOption(CompressOption option) {
        this.option = option;
    }

    @Override
    public URI getEndpoint(String projectName) throws TunnelException {
        if (this.endpoint != null) {
            return this.endpoint;
        }
        URI u = null;
        try {
            u = new URI(this.odps.projects().get(projectName).getTunnelEndpoint(this.quotaName));
        }
        catch (URISyntaxException e) {
            throw new TunnelException(e.getMessage(), e);
        }
        catch (OdpsException e) {
            throw new TunnelException(e.getMessage(), e);
        }
        return u;
    }

    public Odps getOdps() {
        return this.odps;
    }

    public String getQuotaName() {
        return this.quotaName;
    }

    public void setQuotaName(String quotaName) {
        this.quotaName = quotaName;
    }

    protected boolean availableQuotaName() {
        return !StringUtils.isEmpty((String)this.quotaName);
    }
}

