/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.hasher;

import com.aliyun.odps.tunnel.hasher.DefaultHashFactory;
import com.aliyun.odps.tunnel.hasher.HasherFactory;
import com.aliyun.odps.tunnel.hasher.LegacyHashFactory;
import com.aliyun.odps.tunnel.hasher.OdpsHasher;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TypeHasher {
    private static final Map<String, HasherFactory> versionsMap = new LinkedHashMap<String, HasherFactory>();
    private static final String defaultVersion = "default";
    private static final String legacyVersion = "legacy";

    public static String getDefaultVersion() {
        return defaultVersion;
    }

    public static String getLegacyVersion() {
        return legacyVersion;
    }

    public static String getVersion(String version) {
        if (version == null || version.isEmpty() || !versionsMap.containsKey(version)) {
            return TypeHasher.getDefaultVersion();
        }
        return version;
    }

    public static OdpsHasher getHasher(String typeName, String version) {
        HasherFactory factory;
        if (version == null || version.isEmpty()) {
            version = defaultVersion;
        }
        if ((factory = versionsMap.get(version)) == null) {
            throw new RuntimeException("Not supported hash function version:" + version);
        }
        OdpsHasher hasher = factory.getHasher(typeName.toLowerCase());
        if (hasher == null) {
            throw new RuntimeException("Not supported hash function type:" + typeName);
        }
        return hasher;
    }

    public static OdpsHasher getHasher(String typeName) {
        OdpsHasher hasher = TypeHasher.getHasher(typeName, null);
        assert (hasher != null);
        return hasher;
    }

    public static int CombineHashVal(int[] hashVals) {
        int combineHashVal = 0;
        for (int hashVal : hashVals) {
            combineHashVal += hashVal;
        }
        return combineHashVal ^ combineHashVal >> 8;
    }

    public static int CombineHashVal(List<Integer> hashVals) {
        int combineHashVal = 0;
        for (int hashVal : hashVals) {
            combineHashVal += hashVal;
        }
        return combineHashVal ^ combineHashVal >> 8;
    }

    public static void main(String[] args) {
        OdpsHasher hasher = TypeHasher.getHasher("bigint", legacyVersion);
        int[] hash = new int[]{hasher.hash(0L)};
        int prehash = TypeHasher.CombineHashVal(hash) % 3;
        System.out.println(prehash);
        for (long i = 0L; i < 10L; ++i) {
            hash[0] = hasher.hash(i);
            int curhash = TypeHasher.CombineHashVal(hash) % 3;
            System.out.println(i + ": " + curhash);
        }
    }

    static {
        versionsMap.put(defaultVersion, new DefaultHashFactory());
        versionsMap.put(legacyVersion, new LegacyHashFactory());
    }
}

