/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.common.utils.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;

public class Mimetypes {
    public static final String DEFAULT_MIMETYPE = "application/octet-stream";
    private static Mimetypes mimetypes = null;
    private HashMap<String, String> extensionToMimetypeMap = new HashMap();

    private Mimetypes() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Mimetypes getInstance() {
        if (mimetypes != null) {
            return mimetypes;
        }
        mimetypes = new Mimetypes();
        InputStream is = mimetypes.getClass().getResourceAsStream("/mime.types");
        if (is != null) {
            LogUtils.getLog().debug((Object)"Loading mime types from file in the classpath: mime.types");
            try {
                mimetypes.loadMimetypes(is);
            }
            catch (IOException e) {
                LogUtils.getLog().error((Object)"Failed to load mime types from file in the classpath: mime.types", (Throwable)e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            LogUtils.getLog().warn((Object)"Unable to find 'mime.types' file in classpath");
        }
        return mimetypes;
    }

    public void loadMimetypes(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = br.readLine()) != null) {
            StringTokenizer st;
            if ((line = line.trim()).startsWith("#") || line.length() == 0 || (st = new StringTokenizer(line, " \t")).countTokens() <= 1) continue;
            String extension = st.nextToken();
            if (!st.hasMoreTokens()) continue;
            String mimetype = st.nextToken();
            this.extensionToMimetypeMap.put(extension.toLowerCase(), mimetype);
        }
    }

    public String getMimetype(String fileName) {
        String mimeType = this.getMimetypeByExt(fileName);
        if (mimeType != null) {
            return mimeType;
        }
        return DEFAULT_MIMETYPE;
    }

    public String getMimetype(File file) {
        return this.getMimetype(file.getName());
    }

    public String getMimetype(File file, String key) {
        return this.getMimetype(file.getName(), key);
    }

    public String getMimetype(String primaryObject, String secondaryObject) {
        String mimeType = this.getMimetypeByExt(primaryObject);
        if (mimeType != null) {
            return mimeType;
        }
        mimeType = this.getMimetypeByExt(secondaryObject);
        if (mimeType != null) {
            return mimeType;
        }
        return DEFAULT_MIMETYPE;
    }

    private String getMimetypeByExt(String fileName) {
        int lastPeriodIndex = fileName.lastIndexOf(".");
        if (lastPeriodIndex > 0 && lastPeriodIndex + 1 < fileName.length()) {
            String ext = fileName.substring(lastPeriodIndex + 1).toLowerCase();
            if (this.extensionToMimetypeMap.keySet().contains(ext)) {
                String mimetype = this.extensionToMimetypeMap.get(ext);
                return mimetype;
            }
        }
        return null;
    }
}

