/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.ServiceException;
import com.aliyun.oss.common.auth.RequestSigner;
import com.aliyun.oss.common.comm.ExecutionContext;
import com.aliyun.oss.common.comm.HttpMesssage;
import com.aliyun.oss.common.comm.RequestHandler;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.ResponseHandler;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.common.comm.RetryStrategy;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.HttpUtil;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyun.oss.internal.OSSUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;

public abstract class ServiceClient {
    protected ClientConfiguration config;

    protected ServiceClient(ClientConfiguration config) {
        this.config = config;
    }

    public ClientConfiguration getClientConfiguration() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseMessage sendRequest(RequestMessage request, ExecutionContext context) throws ServiceException, ClientException {
        CodingUtils.assertParameterNotNull(request, "request");
        CodingUtils.assertParameterNotNull(context, "context");
        try {
            ResponseMessage responseMessage = this.sendRequestImpl(request, context);
            return responseMessage;
        }
        finally {
            try {
                request.close();
            }
            catch (IOException ex) {
                LogUtils.logException("Unexpected io exception when trying to close http request: ", ex);
                throw new ClientException("Unexpected io exception when trying to close http request: ", ex);
            }
        }
    }

    private ResponseMessage sendRequestImpl(RequestMessage request, ExecutionContext context) throws ClientException, ServiceException {
        RetryStrategy retryStrategy;
        RetryStrategy retryStrategy2 = retryStrategy = context.getRetryStrategy() != null ? context.getRetryStrategy() : this.getDefaultRetryStrategy();
        if (context.getSigner() != null && !request.isUseUrlSignature()) {
            context.getSigner().sign(request);
        }
        for (RequestSigner signer : context.getSignerHandlers()) {
            signer.sign(request);
        }
        InputStream requestContent = request.getContent();
        if (requestContent != null && requestContent.markSupported()) {
            requestContent.mark(524288);
        }
        int retries = 0;
        ResponseMessage response = null;
        while (true) {
            try {
                if (retries > 0) {
                    this.pause(retries, retryStrategy);
                    if (requestContent != null && requestContent.markSupported()) {
                        try {
                            requestContent.reset();
                            request.setContent(requestContent);
                        }
                        catch (IOException ex) {
                            LogUtils.logException("Failed to reset the request input stream: ", ex);
                            throw new ClientException("Failed to reset the request input stream: ", ex);
                        }
                    }
                }
                this.handleRequest(request, context.getResquestHandlers());
                Request httpRequest = this.buildRequest(request, context);
                String poolStatsInfo = this.config.isLogConnectionPoolStatsEnable() ? "Connection pool stats " + this.getConnectionPoolStats() : "";
                long startTime = System.currentTimeMillis();
                response = this.sendRequestCore(httpRequest, context);
                long duration = System.currentTimeMillis() - startTime;
                if (duration > this.config.getSlowRequestsThreshold()) {
                    LogUtils.getLog().warn((Object)(this.formatSlowRequestLog(request, response, duration) + poolStatsInfo));
                }
                this.handleResponse(response, context.getResponseHandlers());
                ResponseMessage responseMessage = response;
                return responseMessage;
            }
            catch (ServiceException sex) {
                LogUtils.logException("[Server]Unable to execute HTTP request: ", sex, request.getOriginalRequest().isLogEnabled());
                this.closeResponseSilently(response);
                if (this.shouldRetry(sex, request, response, retries, retryStrategy)) continue;
                throw sex;
            }
            catch (ClientException cex) {
                LogUtils.logException("[Client]Unable to execute HTTP request: ", cex, request.getOriginalRequest().isLogEnabled());
                this.closeResponseSilently(response);
                if (this.shouldRetry(cex, request, response, retries, retryStrategy)) continue;
                throw cex;
            }
            catch (Exception ex) {
                LogUtils.logException("[Unknown]Unable to execute HTTP request: ", ex, request.getOriginalRequest().isLogEnabled());
                this.closeResponseSilently(response);
                throw new ClientException(OSSUtils.COMMON_RESOURCE_MANAGER.getFormattedString("ConnectionError", ex.getMessage()), ex);
            }
            finally {
                ++retries;
                continue;
            }
            break;
        }
    }

    protected abstract ResponseMessage sendRequestCore(Request var1, ExecutionContext var2) throws IOException;

    private Request buildRequest(RequestMessage requestMessage, ExecutionContext context) throws ClientException {
        boolean putParamsInUri;
        Request request = new Request();
        request.setMethod(requestMessage.getMethod());
        request.setUseChunkEncoding(requestMessage.isUseChunkEncoding());
        if (requestMessage.isUseUrlSignature()) {
            request.setUrl(requestMessage.getAbsoluteUrl().toString());
            request.setUseUrlSignature(true);
            request.setContent(requestMessage.getContent());
            request.setContentLength(requestMessage.getContentLength());
            request.setHeaders(requestMessage.getHeaders());
            return request;
        }
        request.setHeaders(requestMessage.getHeaders());
        if (request.getHeaders() != null) {
            HttpUtil.convertHeaderCharsetToIso88591(request.getHeaders());
        }
        String delimiter = "/";
        String uri = requestMessage.getEndpoint().toString();
        if (!(uri.endsWith("/") || requestMessage.getResourcePath() != null && requestMessage.getResourcePath().startsWith("/"))) {
            uri = uri + "/";
        }
        if (requestMessage.getResourcePath() != null) {
            uri = uri + requestMessage.getResourcePath();
        }
        String paramString = HttpUtil.paramToQueryString(requestMessage.getParameters(), context.getCharset());
        boolean requestHasNoPayload = requestMessage.getContent() != null;
        boolean requestIsPost = requestMessage.getMethod() == HttpMethod.POST;
        boolean bl = putParamsInUri = !requestIsPost || requestHasNoPayload;
        if (paramString != null && putParamsInUri) {
            uri = uri + "?" + paramString;
        }
        request.setUrl(uri);
        if (requestIsPost && requestMessage.getContent() == null && paramString != null) {
            try {
                byte[] buf = paramString.getBytes(context.getCharset());
                ByteArrayInputStream content = new ByteArrayInputStream(buf);
                request.setContent(content);
                request.setContentLength(buf.length);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(OSSUtils.COMMON_RESOURCE_MANAGER.getFormattedString("EncodingFailed", e.getMessage()));
            }
        } else {
            request.setContent(requestMessage.getContent());
            request.setContentLength(requestMessage.getContentLength());
        }
        return request;
    }

    private void handleResponse(ResponseMessage response, List<ResponseHandler> responseHandlers) throws ServiceException, ClientException {
        for (ResponseHandler h : responseHandlers) {
            h.handle(response);
        }
    }

    private void handleRequest(RequestMessage message, List<RequestHandler> resquestHandlers) throws ServiceException, ClientException {
        for (RequestHandler h : resquestHandlers) {
            h.handle(message);
        }
    }

    private void pause(int retries, RetryStrategy retryStrategy) throws ClientException {
        long delay = retryStrategy.getPauseDelay(retries);
        LogUtils.getLog().debug((Object)("An retriable error request will be retried after " + delay + "(ms) with attempt times: " + retries));
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            throw new ClientException(e.getMessage(), e);
        }
    }

    private boolean shouldRetry(Exception exception, RequestMessage request, ResponseMessage response, int retries, RetryStrategy retryStrategy) {
        if (retries >= this.config.getMaxErrorRetry()) {
            return false;
        }
        if (!request.isRepeatable()) {
            return false;
        }
        if (retryStrategy.shouldRetry(exception, request, response, retries)) {
            LogUtils.getLog().debug((Object)("Retrying on " + exception.getClass().getName() + ": " + exception.getMessage()));
            return true;
        }
        return false;
    }

    private void closeResponseSilently(ResponseMessage response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String formatSlowRequestLog(RequestMessage request, ResponseMessage response, long useTimesMs) {
        return String.format("Request cost %d seconds, endpoint %s, resourcePath %s, method %s, Date '%s', statusCode %d, requestId %s.", new Object[]{useTimesMs / 1000L, request.getEndpoint(), request.getResourcePath(), request.getMethod(), request.getHeaders().get("Date"), response.getStatusCode(), response.getRequestId()});
    }

    protected abstract RetryStrategy getDefaultRetryStrategy();

    public abstract void shutdown();

    public String getConnectionPoolStats() {
        return "";
    }

    public static class Request
    extends HttpMesssage {
        private String uri;
        private HttpMethod method;
        private boolean useUrlSignature = false;
        private boolean useChunkEncoding = false;

        public String getUri() {
            return this.uri;
        }

        public void setUrl(String uri) {
            this.uri = uri;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public void setMethod(HttpMethod method) {
            this.method = method;
        }

        public boolean isUseUrlSignature() {
            return this.useUrlSignature;
        }

        public void setUseUrlSignature(boolean useUrlSignature) {
            this.useUrlSignature = useUrlSignature;
        }

        public boolean isUseChunkEncoding() {
            return this.useChunkEncoding;
        }

        public void setUseChunkEncoding(boolean useChunkEncoding) {
            this.useChunkEncoding = useChunkEncoding;
        }
    }
}

