/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.model;

import com.aliyun.oss.event.ProgressEventType;
import com.aliyun.oss.event.ProgressListener;
import com.aliyun.oss.event.ProgressPublisher;
import com.aliyun.oss.model.SelectObjectMetadata;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;

public class CreateSelectMetaInputStream
extends FilterInputStream {
    private static final int CONTINUOUS_FRAME_MAGIC = 0x800004;
    private static final int END_FRAME_MAGIC = 0x800006;
    private static final int SELECT_VERSION = 1;
    private static final long DEFAULT_NOTIFICATION_THRESHOLD = 0x3200000L;
    private long currentFrameOffset = 0L;
    private long currentFramePayloadLength = 0L;
    private byte[] currentFrameTypeBytes = new byte[4];
    private byte[] currentFramePayloadLengthBytes = new byte[4];
    private byte[] currentFrameHeaderChecksumBytes = new byte[4];
    private byte[] scannedDataBytes = new byte[8];
    private byte[] currentFramePayloadChecksumBytes = new byte[4];
    private boolean finished = false;
    private ProgressListener selectProgressListener;
    private long nextNotificationScannedSize;
    private CRC32 crc32;
    private SelectObjectMetadata selectObjectMetadata;
    private boolean firstReadFrame = true;

    public CreateSelectMetaInputStream(InputStream in, SelectObjectMetadata selectObjectMetadata, ProgressListener selectProgressListener) {
        super(in);
        this.selectObjectMetadata = selectObjectMetadata;
        this.selectProgressListener = selectProgressListener;
        this.nextNotificationScannedSize = 0x3200000L;
        this.crc32 = new CRC32();
        this.crc32.reset();
    }

    private void internalRead(byte[] buf, int off, int len) throws IOException {
        int bytes;
        for (int bytesRead = 0; bytesRead < len; bytesRead += bytes) {
            bytes = this.in.read(buf, off + bytesRead, len - bytesRead);
            if (bytes >= 0) continue;
            throw new IOException("invalid input stream end found, need another " + (len - bytesRead) + "bytes");
        }
    }

    private void validateCheckSum(byte[] checksumBytes, CRC32 crc32) throws IOException {
        int currentChecksum = ByteBuffer.wrap(checksumBytes).getInt();
        if (crc32.getValue() != ((long)currentChecksum & 0xFFFFFFFFL)) {
            throw new IOException("select frame crc check failed, actual: " + crc32.getValue() + ", expect: " + currentChecksum);
        }
        crc32.reset();
    }

    private void readFrame() throws IOException {
        while (this.currentFrameOffset >= this.currentFramePayloadLength && !this.finished) {
            long scannedDataSize;
            if (!this.firstReadFrame) {
                this.internalRead(this.currentFramePayloadChecksumBytes, 0, 4);
                this.validateCheckSum(this.currentFramePayloadChecksumBytes, this.crc32);
            }
            this.firstReadFrame = false;
            this.internalRead(this.currentFrameTypeBytes, 0, 4);
            if (this.currentFrameTypeBytes[0] != 1) {
                throw new IOException("invalid select version found: " + this.currentFrameTypeBytes[0] + ", expect: " + 1);
            }
            this.internalRead(this.currentFramePayloadLengthBytes, 0, 4);
            this.internalRead(this.currentFrameHeaderChecksumBytes, 0, 4);
            this.internalRead(this.scannedDataBytes, 0, 8);
            this.crc32.update(this.scannedDataBytes);
            this.currentFrameTypeBytes[0] = 0;
            int type = ByteBuffer.wrap(this.currentFrameTypeBytes).getInt();
            switch (type) {
                case 0x800004: {
                    break;
                }
                case 0x800006: {
                    this.currentFramePayloadLength = ByteBuffer.wrap(this.currentFramePayloadLengthBytes).getInt() - 8;
                    byte[] totalScannedDataSizeBytes = new byte[8];
                    this.internalRead(totalScannedDataSizeBytes, 0, 8);
                    byte[] statusBytes = new byte[4];
                    this.internalRead(statusBytes, 0, 4);
                    byte[] splitBytes = new byte[4];
                    this.internalRead(splitBytes, 0, 4);
                    byte[] totalLineBytes = new byte[8];
                    this.internalRead(totalLineBytes, 0, 8);
                    byte[] columnBytes = new byte[4];
                    this.internalRead(columnBytes, 0, 4);
                    this.crc32.update(totalScannedDataSizeBytes);
                    this.crc32.update(statusBytes);
                    this.crc32.update(splitBytes);
                    this.crc32.update(totalLineBytes);
                    this.crc32.update(columnBytes);
                    int status = ByteBuffer.wrap(statusBytes).getInt();
                    int errorMessageSize = (int)(this.currentFramePayloadLength - 28L);
                    String error = "";
                    if (errorMessageSize > 0) {
                        byte[] errorMessageBytes = new byte[errorMessageSize];
                        this.internalRead(errorMessageBytes, 0, errorMessageSize);
                        error = new String(errorMessageBytes);
                        this.crc32.update(errorMessageBytes);
                    }
                    this.finished = true;
                    this.currentFramePayloadLength = this.currentFrameOffset;
                    this.internalRead(this.currentFramePayloadChecksumBytes, 0, 4);
                    this.validateCheckSum(this.currentFramePayloadChecksumBytes, this.crc32);
                    if (status / 100 != 2) {
                        throw new IOException("Oss Select create meta encounter error code: " + status + ", message: " + error);
                    }
                    this.selectObjectMetadata.withCsvObjectMetadata(new SelectObjectMetadata.CSVObjectMetadata().withSplits(ByteBuffer.wrap(splitBytes).getInt()).withTotalLines(ByteBuffer.wrap(totalLineBytes).getLong()));
                    break;
                }
                default: {
                    throw new IOException("unsupported frame type found: " + type);
                }
            }
            ProgressEventType eventType = ProgressEventType.SELECT_SCAN_EVENT;
            if (this.finished) {
                eventType = ProgressEventType.SELECT_COMPLETED_EVENT;
            }
            if ((scannedDataSize = ByteBuffer.wrap(this.scannedDataBytes).getLong()) < this.nextNotificationScannedSize && !this.finished) continue;
            ProgressPublisher.publishSelectProgress(this.selectProgressListener, eventType, scannedDataSize);
            this.nextNotificationScannedSize += 0x3200000L;
        }
    }

    @Override
    public int read() throws IOException {
        this.readFrame();
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        this.readFrame();
        return -1;
    }

    @Override
    public int available() throws IOException {
        throw new IOException("create select meta input stream does not support available() operation");
    }
}

