/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.model;

import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.LifecycleRule;
import java.util.ArrayList;
import java.util.List;

public class SetBucketLifecycleRequest
extends GenericRequest {
    public static final int MAX_LIFECYCLE_RULE_LIMIT = 1000;
    public static final int MAX_RULE_ID_LENGTH = 255;
    private List<LifecycleRule> lifecycleRules = new ArrayList<LifecycleRule>();

    public SetBucketLifecycleRequest(String bucketName) {
        super(bucketName);
    }

    public List<LifecycleRule> getLifecycleRules() {
        return this.lifecycleRules;
    }

    public void setLifecycleRules(List<LifecycleRule> lifecycleRules) {
        if (lifecycleRules == null || lifecycleRules.isEmpty()) {
            throw new IllegalArgumentException("lifecycleRules should not be null or empty.");
        }
        if (lifecycleRules.size() > 1000) {
            throw new IllegalArgumentException("One bucket not allow exceed one thousand items of LifecycleRules.");
        }
        this.lifecycleRules.clear();
        this.lifecycleRules.addAll(lifecycleRules);
    }

    public void clearLifecycles() {
        this.lifecycleRules.clear();
    }

    public void AddLifecycleRule(LifecycleRule lifecycleRule) {
        LifecycleRule.AbortMultipartUpload abortMultipartUpload;
        int createdBeforeDateFlag;
        int expirationDaysFlag;
        if (lifecycleRule == null) {
            throw new IllegalArgumentException("lifecycleRule should not be null or empty.");
        }
        if (this.lifecycleRules.size() >= 1000) {
            throw new IllegalArgumentException("One bucket not allow exceed one thousand items of LifecycleRules.");
        }
        if (lifecycleRule.getId() != null && lifecycleRule.getId().length() > 255) {
            throw new IllegalArgumentException("Length of lifecycle rule id exceeds max limit 255");
        }
        int expirationTimeFlag = lifecycleRule.hasExpirationTime() ? 1 : 0;
        int flagSum = expirationTimeFlag + (expirationDaysFlag = lifecycleRule.hasExpirationDays() ? 1 : 0) + (createdBeforeDateFlag = lifecycleRule.hasCreatedBeforeDate() ? 1 : 0);
        if (flagSum > 1 || flagSum == 0 && !lifecycleRule.hasAbortMultipartUpload() && !lifecycleRule.hasStorageTransition()) {
            throw new IllegalArgumentException("Only one expiration property should be specified.");
        }
        if (lifecycleRule.getStatus() == LifecycleRule.RuleStatus.Unknown) {
            throw new IllegalArgumentException("RuleStatus property should be specified with 'Enabled' or 'Disabled'.");
        }
        if (lifecycleRule.hasAbortMultipartUpload() && (flagSum = (expirationDaysFlag = (abortMultipartUpload = lifecycleRule.getAbortMultipartUpload()).hasExpirationDays() ? 1 : 0) + (createdBeforeDateFlag = abortMultipartUpload.hasCreatedBeforeDate() ? 1 : 0)) != 1) {
            throw new IllegalArgumentException("Only one expiration property for AbortMultipartUpload should be specified.");
        }
        if (lifecycleRule.hasStorageTransition()) {
            for (LifecycleRule.StorageTransition storageTransition : lifecycleRule.getStorageTransition()) {
                expirationDaysFlag = storageTransition.hasExpirationDays() ? 1 : 0;
                flagSum = expirationDaysFlag + (createdBeforeDateFlag = storageTransition.hasCreatedBeforeDate() ? 1 : 0);
                if (flagSum == 1) continue;
                throw new IllegalArgumentException("Only one expiration property for StorageTransition should be specified.");
            }
        }
        this.lifecycleRules.add(lifecycleRule);
    }
}

