/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss;

import com.aliyun.oss.AsyncHandler;
import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSAsync;
import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.common.comm.DefaultServiceClient;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.comm.SignVersion;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyun.oss.internal.OSSBucketOperation;
import com.aliyun.oss.internal.OSSObjectOperation;
import com.aliyun.oss.model.AppendObjectRequest;
import com.aliyun.oss.model.AppendObjectResult;
import com.aliyun.oss.model.CopyObjectRequest;
import com.aliyun.oss.model.CopyObjectResult;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.HeadObjectRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSFuture;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.SimplifiedObjectMeta;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;

public class OSSAsyncClient
implements OSSAsync {
    private CredentialsProvider credsProvider;
    private URI endpoint;
    private ServiceClient serviceClient;
    private OSSBucketOperation bucketOperation;
    private OSSObjectOperation objectOperation;

    public OSSAsyncClient(String endpoint, CredentialsProvider credsProvider, ClientConfiguration config) {
        this.credsProvider = credsProvider;
        config = config == null ? new ClientConfiguration() : config;
        this.serviceClient = new DefaultServiceClient(config);
        this.initOperations();
        this.setEndpoint(endpoint);
    }

    public OSSAsyncClient(String endpoint, String accessKeyId, String secretAccessKey) {
        this(endpoint, new DefaultCredentialProvider(accessKeyId, secretAccessKey), null);
    }

    public OSSAsyncClient(String endpoint, String accessKeyId, String secretAccessKey, ClientConfiguration config) {
        this(endpoint, new DefaultCredentialProvider(accessKeyId, secretAccessKey), config);
    }

    public synchronized void setEndpoint(String endpoint) {
        URI uri;
        this.endpoint = uri = this.toURI(endpoint);
        if (this.isIpOrLocalhost(uri)) {
            this.serviceClient.getClientConfiguration().setSLDEnabled(true);
        }
        this.bucketOperation.setEndpoint(uri);
        this.objectOperation.setEndpoint(uri);
    }

    private boolean isIpOrLocalhost(URI uri) {
        InetAddress ia;
        if (uri.getHost().equals("localhost")) {
            return true;
        }
        try {
            ia = InetAddress.getByName(uri.getHost());
        }
        catch (UnknownHostException e) {
            return false;
        }
        return uri.getHost().equals(ia.getHostAddress());
    }

    private URI toURI(String endpoint) throws IllegalArgumentException {
        if (!endpoint.contains("://")) {
            ClientConfiguration conf = this.serviceClient.getClientConfiguration();
            endpoint = conf.getProtocol().toString() + "://" + endpoint;
        }
        try {
            return new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void initOperations() {
        this.bucketOperation = new OSSBucketOperation(this.serviceClient, this.credsProvider);
        this.objectOperation = new OSSObjectOperation(this.serviceClient, this.credsProvider);
    }

    @Override
    public void switchCredentials(Credentials creds) {
        if (creds == null) {
            throw new IllegalArgumentException("creds should not be null.");
        }
        this.credsProvider.setCredentials(creds);
    }

    @Override
    public void switchSignatureVersion(SignVersion signatureVersion) {
        if (signatureVersion == null) {
            throw new IllegalArgumentException("signatureVersion should not be null.");
        }
        this.getClientConfiguration().setSignatureVersion(signatureVersion);
    }

    @Override
    public OSSFuture<PutObjectResult> putObject(PutObjectRequest putObjectRequest, AsyncHandler<PutObjectResult> handler) throws ClientException {
        return this.objectOperation.asyncPutObject(putObjectRequest, handler);
    }

    @Override
    public OSSFuture<ObjectMetadata> getObject(GetObjectRequest getObjectRequest, File file, AsyncHandler<ObjectMetadata> handler) throws ClientException {
        return this.objectOperation.asyncGetObject(getObjectRequest, file, handler);
    }

    @Override
    public OSSFuture<OSSObject> getObject(GetObjectRequest getObjectRequest, AsyncHandler<OSSObject> handler) throws ClientException {
        return this.objectOperation.asyncGetObject(getObjectRequest, handler);
    }

    @Override
    public OSSFuture<CopyObjectResult> copyObject(CopyObjectRequest copyObjectRequest, AsyncHandler<CopyObjectResult> handler) throws ClientException {
        return this.objectOperation.asyncCopyObject(copyObjectRequest, handler);
    }

    @Override
    public OSSFuture<AppendObjectResult> appendObject(AppendObjectRequest appendObjectRequest, AsyncHandler<AppendObjectResult> handler) throws ClientException {
        return this.objectOperation.asyncAppendObject(appendObjectRequest, handler);
    }

    @Override
    public OSSFuture<SimplifiedObjectMeta> getSimplifiedObjectMeta(GenericRequest genericRequest, AsyncHandler<SimplifiedObjectMeta> handler) throws ClientException {
        return this.objectOperation.asyncGetSimplifiedObjectMeta(genericRequest, handler);
    }

    @Override
    public OSSFuture<ObjectMetadata> headObject(HeadObjectRequest headObjectRequest, AsyncHandler<ObjectMetadata> handler) throws ClientException {
        return this.objectOperation.asyncHeadObject(headObjectRequest, handler);
    }

    @Override
    public OSSFuture<ObjectListing> listObjects(ListObjectsRequest listObjectsRequest, AsyncHandler<ObjectListing> handler) throws ClientException {
        return this.bucketOperation.asyncListObjects(listObjectsRequest, handler);
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credsProvider;
    }

    public ClientConfiguration getClientConfiguration() {
        return this.serviceClient.getClientConfiguration();
    }

    @Override
    public void shutdown() {
        try {
            this.serviceClient.shutdown();
        }
        catch (Exception e) {
            LogUtils.logException("shutdown throw exception: ", e);
        }
    }
}

