/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.common.comm.ExecutionContext;
import com.aliyun.oss.common.comm.RepeatableInputStreamEntity;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.comm.UnRepeatableInputStreamEntity;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;

class HttpRequestFactory {
    HttpRequestFactory() {
    }

    public Request createHttpRequest(ServiceClient.Request request, ExecutionContext context) {
        Request.Builder builder = this.createHttpRequestBuilder(request, context);
        return builder.build();
    }

    private Request.Builder createHttpRequestBuilder(ServiceClient.Request request, ExecutionContext context) {
        Request.Builder builder = new Request.Builder();
        String uri = request.getUri();
        HttpMethod method = request.getMethod();
        if (method == HttpMethod.POST) {
            RepeatableInputStreamEntity requestBody = null;
            if (request.getContent() != null) {
                requestBody = request.getContent().markSupported() ? new RepeatableInputStreamEntity(request) : new UnRepeatableInputStreamEntity(request);
            }
            builder.post(requestBody);
        } else if (method == HttpMethod.PUT) {
            RequestBody requestBody;
            if (request.getContent() != null) {
                if (request.isUseChunkEncoding()) {
                    builder.header("Transfer-Encoding", "chunked");
                }
                requestBody = request.getContent().markSupported() ? new RepeatableInputStreamEntity(request) : new UnRepeatableInputStreamEntity(request);
            } else {
                requestBody = new RequestBody(){

                    public MediaType contentType() {
                        return null;
                    }

                    public void writeTo(BufferedSink sink) {
                    }
                };
            }
            builder.put(requestBody);
        } else if (method == HttpMethod.GET) {
            builder.get();
        } else if (method == HttpMethod.DELETE) {
            builder.delete();
        } else if (method == HttpMethod.HEAD) {
            builder.head();
        } else if (method == HttpMethod.OPTIONS) {
            builder.method("OPTIONS", null);
        } else {
            throw new ClientException("Unknown HTTP method name: " + method.toString());
        }
        builder.url(uri);
        this.configureRequestHeaders(request, context, builder);
        return builder;
    }

    private void configureRequestHeaders(ServiceClient.Request request, ExecutionContext context, Request.Builder builder) {
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length") || entry.getKey().equalsIgnoreCase("Host")) continue;
            builder.addHeader(entry.getKey(), entry.getValue());
        }
    }
}

