/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm;

import com.aliyun.oss.common.comm.ServiceClient;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class RepeatableInputStreamEntity
extends RequestBody {
    private boolean firstAttempt = true;
    private InputStream content;
    private MediaType mediaType;
    private long contentLength;

    public RepeatableInputStreamEntity(ServiceClient.Request request) {
        InputStream content = request.getContent();
        if (content == null) {
            throw new IllegalArgumentException("Source input stream may not be null");
        }
        this.content = content;
        this.contentLength = request.getContentLength();
        String contentType = request.getHeaders().get("Content-Type");
        if (contentType != null) {
            this.mediaType = MediaType.parse((String)contentType);
        }
    }

    public MediaType contentType() {
        return this.mediaType;
    }

    public boolean isRepeatable() {
        return true;
    }

    public long contentLength() throws IOException {
        return this.contentLength;
    }

    public void writeTo(BufferedSink bufferedSink) throws IOException {
        if (!this.firstAttempt && this.isRepeatable()) {
            this.content.reset();
        }
        this.firstAttempt = false;
        Source source = Okio.source((InputStream)this.content);
        bufferedSink.writeAll(source);
    }
}

