/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.transport.netty;

import akka.event.LogMarker$;
import akka.event.MarkerLoggingAdapter;
import akka.japi.Util$;
import akka.remote.RemoteTransportException;
import akka.remote.security.provider.AkkaProvider$;
import com.alibaba.schedulerx.shade.scala.Serializable;
import com.alibaba.schedulerx.shade.scala.collection.immutable.Set;
import com.alibaba.schedulerx.shade.scala.collection.immutable.Set$;
import com.alibaba.schedulerx.shade.scala.collection.mutable.StringBuilder;
import com.alibaba.schedulerx.shade.scala.reflect.ScalaSignature;
import com.alibaba.schedulerx.shade.scala.util.Try$;
import com.typesafe.config.Config;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

@ScalaSignature(bytes="\u0006\u0001\u0005-b!B\u0001\u0003\u0001!Q!aC*T\u0019N+G\u000f^5oONT!a\u0001\u0003\u0002\u000b9,G\u000f^=\u000b\u0005\u00151\u0011!\u0003;sC:\u001c\bo\u001c:u\u0015\t9\u0001\"\u0001\u0004sK6|G/\u001a\u0006\u0002\u0013\u0005!\u0011m[6b'\t\u00011\u0002\u0005\u0002\r\u001f5\tQBC\u0001\u000f\u0003\u0015\u00198-\u00197b\u0013\t\u0001RB\u0001\u0004B]f\u0014VM\u001a\u0005\t%\u0001\u0011\t\u0011)A\u0005)\u000511m\u001c8gS\u001e\u001c\u0001\u0001\u0005\u0002\u001675\taC\u0003\u0002\u0013/)\u0011\u0001$G\u0001\tif\u0004Xm]1gK*\t!$A\u0002d_6L!\u0001\b\f\u0003\r\r{gNZ5h\u0011\u0015q\u0002\u0001\"\u0001 \u0003\u0019a\u0014N\\5u}Q\u0011\u0001E\t\t\u0003C\u0001i\u0011A\u0001\u0005\u0006%u\u0001\r\u0001\u0006\u0005\bI\u0001\u0011\r\u0011\"\u0001&\u0003-\u00196\u000bT&fsN#xN]3\u0016\u0003\u0019\u0002\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\t1\fgn\u001a\u0006\u0002W\u0005!!.\u0019<b\u0013\ti\u0003F\u0001\u0004TiJLgn\u001a\u0005\u0007_\u0001\u0001\u000b\u0011\u0002\u0014\u0002\u0019M\u001bFjS3z'R|'/\u001a\u0011\t\u000fE\u0002!\u0019!C\u0001K\u0005i1k\u0015'UeV\u001cHo\u0015;pe\u0016Daa\r\u0001!\u0002\u00131\u0013AD*T\u0019R\u0013Xo\u001d;Ti>\u0014X\r\t\u0005\bk\u0001\u0011\r\u0011\"\u0001&\u0003M\u00196\u000bT&fsN#xN]3QCN\u001cxo\u001c:e\u0011\u00199\u0004\u0001)A\u0005M\u0005!2k\u0015'LKf\u001cFo\u001c:f!\u0006\u001c8o^8sI\u0002Bq!\u000f\u0001C\u0002\u0013\u0005Q%\u0001\bT'2[U-\u001f)bgN<xN\u001d3\t\rm\u0002\u0001\u0015!\u0003'\u0003=\u00196\u000bT&fsB\u000b7o]<pe\u0012\u0004\u0003bB\u001f\u0001\u0005\u0004%\t!J\u0001\u0016'NcEK];tiN#xN]3QCN\u001cxo\u001c:e\u0011\u0019y\u0004\u0001)A\u0005M\u000512k\u0015'UeV\u001cHo\u0015;pe\u0016\u0004\u0016m]:x_J$\u0007\u0005C\u0004B\u0001\t\u0007I\u0011\u0001\"\u0002)M\u001bF*\u00128bE2,G-\u00117h_JLG\u000f[7t+\u0005\u0019\u0005c\u0001#HM9\u0011A\"R\u0005\u0003\r6\ta\u0001\u0015:fI\u00164\u0017B\u0001%J\u0005\r\u0019V\r\u001e\u0006\u0003\r6Aaa\u0013\u0001!\u0002\u0013\u0019\u0015!F*T\u0019\u0016s\u0017M\u00197fI\u0006cwm\u001c:ji\"l7\u000f\t\u0005\b\u001b\u0002\u0011\r\u0011\"\u0001&\u0003-\u00196\u000b\u0014)s_R|7m\u001c7\t\r=\u0003\u0001\u0015!\u0003'\u00031\u00196\u000b\u0014)s_R|7m\u001c7!\u0011\u001d\t\u0006A1A\u0005\u0002\u0015\n\u0001dU*M%\u0006tGm\\7Ok6\u0014WM]$f]\u0016\u0014\u0018\r^8s\u0011\u0019\u0019\u0006\u0001)A\u0005M\u0005I2k\u0015'SC:$w.\u001c(v[\n,'oR3oKJ\fGo\u001c:!\u0011\u001d)\u0006A1A\u0005\u0002Y\u000badU*M%\u0016\fX/\u001b:f\u001bV$X/\u00197BkRDWM\u001c;jG\u0006$\u0018n\u001c8\u0016\u0003]\u0003\"\u0001\u0004-\n\u0005ek!a\u0002\"p_2,\u0017M\u001c\u0005\u00077\u0002\u0001\u000b\u0011B,\u0002?M\u001bFJU3rk&\u0014X-T;uk\u0006d\u0017)\u001e;iK:$\u0018nY1uS>t\u0007\u0005C\u0004^\u0001\t\u0007I\u0011\u00020\u0002\u0015M\u001cHnQ8oi\u0016DH/F\u0001`!\r\u0001w-[\u0007\u0002C*\u0011!mY\u0001\u0007CR|W.[2\u000b\u0005\u0011,\u0017AC2p]\u000e,(O]3oi*\u0011aMK\u0001\u0005kRLG.\u0003\u0002iC\ny\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0002kc6\t1N\u0003\u0002m[\u0006\u00191o\u001d7\u000b\u00059|\u0017a\u00018fi*\t\u0001/A\u0003kCZ\f\u00070\u0003\u0002sW\nQ1k\u0015'D_:$X\r\u001f;\t\rQ\u0004\u0001\u0015!\u0003`\u0003-\u00198\u000f\\\"p]R,\u0007\u0010\u001e\u0011\t\u000bY\u0004AQA<\u0002%\u001d,Go\u0014:De\u0016\fG/Z\"p]R,\u0007\u0010\u001e\u000b\u0003SbDQ!_;A\u0002i\f1\u0001\\8h!\tYh0D\u0001}\u0015\ti\b\"A\u0003fm\u0016tG/\u0003\u0002\u0000y\n!R*\u0019:lKJdunZ4j]\u001e\fE-\u00199uKJD3!^A\u0002!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005\u001b\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u0011q\u0001\u0002\bi\u0006LGN]3d\u0011\u001d\t\t\u0002\u0001C\u0005\u0003'\t\u0001cY8ogR\u0014Xo\u0019;D_:$X\r\u001f;\u0015\u0007%\f)\u0002\u0003\u0004z\u0003\u001f\u0001\rA\u001f\u0005\b\u00033\u0001A\u0011AA\u000e\u0003I\u0019'/Z1uKN+7-\u001e:f%\u0006tGm\\7\u0015\t\u0005u\u0011\u0011\u0006\t\u0005\u0003?\t)#\u0004\u0002\u0002\")\u0019\u00111\u0005\u0016\u0002\u0011M,7-\u001e:jifLA!a\n\u0002\"\ta1+Z2ve\u0016\u0014\u0016M\u001c3p[\"1\u00110a\u0006A\u0002i\u0004")
public class SSLSettings {
    private final String SSLKeyStore;
    private final String SSLTrustStore;
    private final String SSLKeyStorePassword;
    private final String SSLKeyPassword;
    private final String SSLTrustStorePassword;
    private final Set<String> SSLEnabledAlgorithms;
    private final String SSLProtocol;
    private final String SSLRandomNumberGenerator;
    private final boolean SSLRequireMutualAuthentication;
    private final AtomicReference<SSLContext> sslContext;

    public String SSLKeyStore() {
        return this.SSLKeyStore;
    }

    public String SSLTrustStore() {
        return this.SSLTrustStore;
    }

    public String SSLKeyStorePassword() {
        return this.SSLKeyStorePassword;
    }

    public String SSLKeyPassword() {
        return this.SSLKeyPassword;
    }

    public String SSLTrustStorePassword() {
        return this.SSLTrustStorePassword;
    }

    public Set<String> SSLEnabledAlgorithms() {
        return this.SSLEnabledAlgorithms;
    }

    public String SSLProtocol() {
        return this.SSLProtocol;
    }

    public String SSLRandomNumberGenerator() {
        return this.SSLRandomNumberGenerator;
    }

    public boolean SSLRequireMutualAuthentication() {
        return this.SSLRequireMutualAuthentication;
    }

    private AtomicReference<SSLContext> sslContext() {
        return this.sslContext;
    }

    public final SSLContext getOrCreateContext(MarkerLoggingAdapter log) {
        SSLContext sSLContext;
        block1: {
            SSLContext sSLContext2;
            while ((sSLContext2 = this.sslContext().get()) == null) {
                SSLContext newCtx = this.constructContext(log);
                if (!this.sslContext().compareAndSet(null, newCtx)) continue;
                sSLContext = newCtx;
                break block1;
            }
            sSLContext = sSLContext2;
        }
        return sSLContext;
    }

    private SSLContext constructContext(MarkerLoggingAdapter log) {
        try {
            KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            factory.init(this.loadKeystore$1(this.SSLKeyStore(), this.SSLKeyStorePassword()), this.SSLKeyPassword().toCharArray());
            KeyManager[] keyManagers = factory.getKeyManagers();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(this.loadKeystore$1(this.SSLTrustStore(), this.SSLTrustStorePassword()));
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            SecureRandom rng = this.createSecureRandom(log);
            SSLContext ctx = SSLContext.getInstance(this.SSLProtocol());
            ctx.init(keyManagers, trustManagers, rng);
            return ctx;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RemoteTransportException("Server SSL connection could not be established because SSL context could not be constructed", generalSecurityException);
        }
        catch (IOException iOException) {
            throw new RemoteTransportException(new StringBuilder().append((Object)"Server SSL connection could not be established because: ").append((Object)iOException.getMessage()).toString(), iOException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RemoteTransportException("Server SSL connection could not be established because key store could not be loaded", fileNotFoundException);
        }
    }

    /*
     * WARNING - void declaration
     */
    public SecureRandom createSecureRandom(MarkerLoggingAdapter log) {
        void var2_7;
        SecureRandom secureRandom;
        String string2 = this.SSLRandomNumberGenerator();
        boolean bl = "AES128CounterSecureRNG".equals(string2) ? true : "AES256CounterSecureRNG".equals(string2);
        if (bl) {
            log.debug("SSL random number generator set to: {}", (Object)string2);
            secureRandom = SecureRandom.getInstance(string2, AkkaProvider$.MODULE$);
        } else {
            boolean bl2 = "AES128CounterInetRNG".equals(string2) ? true : "AES256CounterInetRNG".equals(string2);
            if (bl2) {
                log.warning(LogMarker$.MODULE$.Security(), "SSL random number generator {} is deprecated, use AES128CounterSecureRNG or AES256CounterSecureRNG instead", (Object)string2);
                secureRandom = SecureRandom.getInstance(string2, AkkaProvider$.MODULE$);
            } else {
                boolean bl3 = "SHA1PRNG".equals(string2) ? true : "NativePRNG".equals(string2);
                if (bl3) {
                    log.debug("SSL random number generator set to: {}", (Object)string2);
                    secureRandom = SecureRandom.getInstance(string2);
                } else if ("".equals(string2)) {
                    log.debug("SSLRandomNumberGenerator not specified, falling back to SecureRandom");
                    secureRandom = new SecureRandom();
                } else {
                    log.warning(LogMarker$.MODULE$.Security(), "Unknown SSLRandomNumberGenerator [{}] falling back to SecureRandom", (Object)string2);
                    secureRandom = new SecureRandom();
                }
            }
        }
        SecureRandom rng = secureRandom;
        rng.nextInt();
        return var2_7;
    }

    /*
     * WARNING - void declaration
     */
    private final KeyStore loadKeystore$1(String filename, String password) {
        void var3_3;
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream fin = new FileInputStream(filename);
        try {
            keyStore.load(fin, password.toCharArray());
            Try$.MODULE$.apply(new Serializable(this, fin){
                public static final long serialVersionUID = 0L;
                private final FileInputStream fin$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.fin$1.close();
                }
                {
                    this.fin$1 = fin$1;
                }
            });
        }
        catch (Throwable throwable) {
            void var4_4;
            Try$.MODULE$.apply(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        return var3_3;
    }

    public SSLSettings(Config config) {
        this.SSLKeyStore = config.getString("key-store");
        this.SSLTrustStore = config.getString("trust-store");
        this.SSLKeyStorePassword = config.getString("key-store-password");
        this.SSLKeyPassword = config.getString("key-password");
        this.SSLTrustStorePassword = config.getString("trust-store-password");
        this.SSLEnabledAlgorithms = Util$.MODULE$.immutableSeq(config.getStringList("enabled-algorithms")).to(Set$.MODULE$.canBuildFrom());
        this.SSLProtocol = config.getString("protocol");
        this.SSLRandomNumberGenerator = config.getString("random-number-generator");
        this.SSLRequireMutualAuthentication = config.getBoolean("require-mutual-authentication");
        this.sslContext = new AtomicReference();
    }
}

