/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.domain;

import com.alibaba.schedulerx.common.exception.domain.ResultCode;

public enum CommonResultCode implements ResultCode
{
    SUCCESS(200, "SUCCESS"),
    SYSTEM_ERROR(-1, "Sorry, system something wrong. Please contact with developer."),
    APP_NOT_EXIST(-1, "aone app not exist, or has no permission."),
    NOT_SUPPORT("Sorry, not support this function."),
    CHANGE_FREE_ERROR("Sorry, changefree system something wrong. Please try later."),
    NO_AVAILABLE_SERVER_ERROR("Sorry, no available SchedulerX server. Please contact with administrators."),
    NO_PERMISSION("Has no permission, please contact with administrators."),
    INSUFFICIENT_PRIVILEGE("Insufficient privilege to perform the operation or access denied."),
    INVALID_PARAMETERS(-2003, "Invalid parameters: %s"),
    JOB_NOT_EXIST("job not exist"),
    JOB_INSTANCE_NOT_EXIST("job instance not exist"),
    WORKFLOW_NOT_EXIST("workflow not exist"),
    WORKFLOW_INSTANCE_NOT_EXIST("workflow instance not exist"),
    JOB_TIME_TYPE_NOT_SUPPORT("time type not support"),
    JOB_PARALLEL_RUNNING_LIMIT("job parallel running limit"),
    WORKFLOW_PARALLEL_RUNNING_LIMIT("workflow parallel running limit"),
    NO_WORKER_AVAILABLE("no worker available"),
    ALL_WORKER_BUSY("all workers are busy"),
    NOT_SUPPORT_APP_VERSION("not supported, please upgrade app version");

    private final int code;
    private final String desc;

    private CommonResultCode(String desc) {
        this.code = -1;
        this.desc = desc;
    }

    private CommonResultCode(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getMessageCode() {
        return CommonResultCode.class.getSimpleName() + "." + this.name();
    }

    @Override
    public String getDesc(Object ... args) {
        return this.desc;
    }
}

