/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.domain.enums;

import com.alibaba.schedulerx.common.domain.CommonResultCode;
import com.alibaba.schedulerx.common.exception.SchedulerxException;

public enum PermissionTypeEnum {
    ALL("*", 3, "all permission"),
    READ_ONLY("r", 1, "read only");

    private String key;
    private int value;
    private String desc;

    private PermissionTypeEnum(String key, int value, String desc) {
        this.key = key;
        this.value = value;
        this.desc = desc;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static boolean isValidType(String type) {
        for (PermissionTypeEnum item : PermissionTypeEnum.values()) {
            if (!item.key.equals(type)) continue;
            return true;
        }
        return false;
    }

    public static PermissionTypeEnum getType(String type) {
        for (PermissionTypeEnum item : PermissionTypeEnum.values()) {
            if (!item.key.equals(type)) continue;
            return item;
        }
        throw new SchedulerxException(CommonResultCode.INVALID_PARAMETERS, new Object[]{"type=" + type});
    }

    public boolean implies(PermissionTypeEnum target) {
        if (target != null) {
            return (this.value & target.value) == target.value;
        }
        return false;
    }
}

