/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.util;

public class IdUtil {
    public static final String SPLITTER_TOKEN = "_";

    public static long parse(String uniqueId, IdType type) {
        String[] tokens = uniqueId.split(SPLITTER_TOKEN, 3);
        switch (type) {
            case JOB_ID: {
                return Long.parseLong(tokens[0]);
            }
            case JOB_INSTANCE_ID: {
                return Long.parseLong(tokens[1]);
            }
        }
        return Long.parseLong(tokens[2]);
    }

    public static String getUniqueId(long jobId, long jobInstanceId, long taskId) {
        return jobId + SPLITTER_TOKEN + jobInstanceId + SPLITTER_TOKEN + taskId;
    }

    public static String getUniqueIdWithoutTask(long jobId, long jobInstanceId) {
        return jobId + SPLITTER_TOKEN + jobInstanceId;
    }

    public static String getRouteStrategyUniqueId(long appGroupId, long jobId) {
        return appGroupId + SPLITTER_TOKEN + jobId;
    }

    public static enum IdType {
        JOB_ID,
        JOB_INSTANCE_ID,
        TASK_ID;

    }
}

