/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.util;

import com.alibaba.schedulerx.common.domain.RouteTargetNode;
import com.alibaba.schedulerx.common.domain.strategy.PercentStrategy;
import java.util.List;
import java.util.Map;

public class RouteUtil {
    public static final int TOTAL_WEIGHT = 100;

    public static String selectTarget(List<PercentStrategy> strategyList, Map<String, RouteTargetNode> map2) {
        if (strategyList == null || map2 == null) {
            return "[]";
        }
        long maxCurrentVal = Long.MIN_VALUE;
        long now = System.currentTimeMillis();
        String selectedTarget = null;
        RouteTargetNode selectedTargetNode = null;
        for (PercentStrategy strategy : strategyList) {
            String target = strategy.getTarget();
            int weight = strategy.getPercentage();
            if (target == null || weight < 0 || weight > 100) continue;
            RouteTargetNode node = map2.get(target);
            if (node == null) {
                node = new RouteTargetNode();
                node.setWeight(weight);
                map2.put(target, node);
                node = map2.get(target);
            }
            if (weight != node.getWeight()) {
                node.setWeight(weight);
            }
            node.setLastUpdateTime(now);
            long currentVal = node.increaseCurrentVal();
            if (currentVal <= maxCurrentVal) continue;
            maxCurrentVal = currentVal;
            selectedTarget = target;
            selectedTargetNode = node;
        }
        if (selectedTarget != null) {
            selectedTargetNode.decreaseCurrentVal(100);
            return selectedTarget;
        }
        return "[]";
    }
}

