/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.util;

import com.alibaba.schedulerx.common.domain.JSONResult;
import com.alibaba.schedulerx.common.domain.RouteStrategyInfoForSync;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.shade.com.google.common.collect.Sets;
import com.alibaba.schedulerx.shade.com.google.gson.reflect.TypeToken;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.HttpResponse;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.JsonNode;
import com.alibaba.schedulerx.shade.com.mashape.unirest.http.Unirest;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UnirestUtil {
    public static <T> Set<T> getSetData(String url, Object ... params) throws Exception {
        String finalUrl = MessageFormat.format(url, UnirestUtil.parseParams(params));
        HttpResponse<JsonNode> jsonResponse = Unirest.get(finalUrl).asJson();
        JSONResult jsonResult = JsonUtil.fromJson(jsonResponse.getBody().toString(), JSONResult.class);
        HashSet data = Sets.newHashSet();
        if (jsonResult != null && jsonResult.getData() != null && jsonResult.getData() instanceof Collection) {
            data = new HashSet((Collection)jsonResult.getData());
        }
        return data;
    }

    public static <T, K> Map<T, K> getMapData(String url, Object ... params) throws Exception {
        String finalUrl = MessageFormat.format(url, UnirestUtil.parseParams(params));
        HttpResponse<JsonNode> jsonResponse = Unirest.get(finalUrl).asJson();
        JSONResult jsonResult = JsonUtil.fromJson(jsonResponse.getBody().toString(), JSONResult.class);
        return (Map)JsonUtil.fromJson(JsonUtil.toJson(jsonResult.getData()), new TypeToken<Map<T, K>>(){}.getType());
    }

    public static JSONResult getResult(String url, Map<String, String> headers, Object ... params) throws Exception {
        String finalUrl = MessageFormat.format(url, UnirestUtil.parseParams(params));
        HttpResponse<JsonNode> jsonResponse = Unirest.get(finalUrl).headers((Map)headers).asJson();
        JSONResult jsonResult = JsonUtil.fromJson(jsonResponse.getBody().toString(), JSONResult.class);
        return jsonResult;
    }

    public static RouteStrategyInfoForSync getObjectData(String url, Object ... params) throws Exception {
        String finalUrl = MessageFormat.format(url, UnirestUtil.parseParams(params));
        HttpResponse<JsonNode> jsonResponse = Unirest.get(finalUrl).asJson();
        JSONResult jsonResult = JsonUtil.fromJson(jsonResponse.getBody().toString(), JSONResult.class);
        return (RouteStrategyInfoForSync)JsonUtil.fromJson(JsonUtil.toJson(jsonResult.getData()), new TypeToken<RouteStrategyInfoForSync>(){}.getType());
    }

    private static String[] parseParams(Object ... params) {
        String[] strValues = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            strValues[i] = String.valueOf(params[i]);
        }
        return strValues;
    }
}

