/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.sdk;

import com.alibaba.schedulerx.common.exception.RequestCheckException;
import com.alibaba.schedulerx.common.sdk.common.ParamValidate;
import com.alibaba.schedulerx.common.sdk.common.SchedulerXResult;
import com.alibaba.schedulerx.common.sdk.request.BaseRequest;
import com.alibaba.schedulerx.common.sdk.request.CreateAppGroupRequest;
import com.alibaba.schedulerx.common.sdk.request.CreateNamespaceRequest;
import com.alibaba.schedulerx.common.sdk.request.GetAppGroupListRequest;
import com.alibaba.schedulerx.common.sdk.request.GetNamespaceListRequest;
import com.alibaba.schedulerx.common.sdk.response.BaseResponse;
import com.alibaba.schedulerx.common.util.SignatureUtil;
import com.alibaba.schedulerx.sdk.http.HttpClientUtil;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiClient {
    private static final Logger logger = LoggerFactory.getLogger(OpenApiClient.class);
    private String appKey;
    private String groupId;
    private String domain;
    @Deprecated
    private String user;
    private String userId;
    private String userName;
    private String namespace;
    private String namespaceSource;
    String OPENAPI_TYPE = "schedulerx-openapi-type";
    String OPENAPI_TYPE_INNER = "inner_sdk";

    public OpenApiClient(String appKey, String groupId, String domain) {
        this.appKey = appKey;
        this.groupId = groupId;
        this.domain = domain.contains("http") ? domain : "http://" + domain;
    }

    @Deprecated
    public OpenApiClient(String appKey, String groupId, String domain, String user) {
        this(appKey, groupId, domain);
        this.user = user;
        this.setUser(user);
    }

    private void setUser(String user) {
        String[] tokens = user.trim().split(" +");
        if (tokens.length == 2) {
            this.userName = tokens[0];
            this.userId = tokens[1];
        } else {
            this.userId = user;
            this.userName = user;
        }
    }

    public OpenApiClient(String domain, String groupId, String appKey, String userId, String userName) {
        this(appKey, groupId, domain);
        this.userId = userId;
        this.userName = userName;
    }

    public OpenApiClient(String domain, String user) {
        this.domain = domain;
        this.user = user;
        this.setUser(user);
        this.domain = domain.contains("http") ? domain : "http://" + domain;
    }

    public <T extends BaseResponse> SchedulerXResult<T> getResponse(BaseRequest<T> request) throws Exception {
        if (this.groupId != null) {
            request.setGroupId(this.groupId);
        }
        if (this.namespace != null) {
            request.setNamespace(this.namespace);
        }
        if (this.namespaceSource != null) {
            request.setNamespaceSource(this.namespaceSource);
        }
        if (this.userId != null) {
            request.getParameterMap().put("userId", this.userId);
        }
        if (this.userName != null) {
            request.getParameterMap().put("userName", this.userName);
        }
        if (this.userId != null && this.userName != null) {
            request.getParameterMap().put("user", this.userName + " " + this.userId);
        } else {
            request.getParameterMap().put("user", StringUtils.isBlank(this.user) ? "openapi" : this.user);
        }
        this.validateCommonParam();
        Map<String, String> headers = this.genHeaders(request);
        ParamValidate.doValidator(request);
        request.preRun();
        logger.info("getResponse url: {} request params : {}", (Object)request.getUrlPath(), (Object)request.getParameterMap().toString());
        return HttpClientUtil.getResponse(request, this.getDomain(), headers);
    }

    private Map<String, String> genHeaders(BaseRequest request) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isNotBlank(this.namespace)) {
            headers.put("schedulerx-namespace", this.namespace);
            if (StringUtils.isNotBlank(this.namespaceSource)) {
                headers.put("schedulerx-namespace-source", this.namespaceSource);
            }
        }
        String timeNow = Long.toString(System.currentTimeMillis());
        headers.put("openapi-timestamp", timeNow);
        if (this.groupId != null && this.appKey != null) {
            headers.put("openapi-signature", SignatureUtil.geneHmacSHA1Encrypt(timeNow, this.groupId, this.appKey));
        }
        headers.put("openapi-groupid", this.groupId);
        if (request instanceof CreateNamespaceRequest) {
            headers.put("openapi-create-namespace", "true");
        } else {
            headers.put("openapi-create-namespace", "false");
        }
        if (request instanceof CreateAppGroupRequest) {
            headers.put("openapi-create-group", "true");
        } else {
            headers.put("openapi-create-group", "false");
        }
        if (request instanceof GetNamespaceListRequest) {
            headers.put("openapi-list-namespaces", "true");
        } else {
            headers.put("openapi-list-namespaces", "false");
        }
        if (request instanceof GetAppGroupListRequest) {
            headers.put("openapi-list-groups", "true");
        } else {
            headers.put("openapi-list-groups", "false");
        }
        headers.put(this.OPENAPI_TYPE, this.OPENAPI_TYPE_INNER);
        return headers;
    }

    private void validateCommonParam() {
        if (StringUtils.isBlank(this.domain)) {
            throw new RequestCheckException("domain is blank");
        }
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getNamespaceSource() {
        return this.namespaceSource;
    }

    public void setNamespaceSource(String namespaceSource) {
        this.namespaceSource = namespaceSource;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
}

