/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.EtlFunctionConfig;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.EtlFunctionFcConfig;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.EtlLogConfig;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.EtlSourceConfig;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.EtlTriggerConfig;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.exception.LogException;
import java.io.Serializable;

public class EtlJob
implements Serializable {
    private static final long serialVersionUID = -5159155546207903399L;
    private String jobName;
    private EtlSourceConfig sourceConfig;
    private EtlTriggerConfig triggerConfig;
    private EtlFunctionConfig functionConfig = null;
    private String functionParameter;
    private EtlLogConfig logConfig;
    boolean enable;

    public EtlSourceConfig getSourceConfig() {
        return this.sourceConfig;
    }

    public void setSourceConfig(EtlSourceConfig sourceConfig) {
        this.sourceConfig = sourceConfig;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public EtlTriggerConfig getTriggerConfig() {
        return this.triggerConfig;
    }

    public void setTriggerConfig(EtlTriggerConfig triggerConfig) {
        this.triggerConfig = triggerConfig;
    }

    public EtlFunctionConfig getFunctionConfig() {
        return this.functionConfig;
    }

    public void setFunctionConfig(EtlFunctionConfig functionConfig) {
        this.functionConfig = functionConfig;
    }

    public String getFunctionParameter() {
        return this.functionParameter;
    }

    public void setFunctionParameter(String functionParameter) {
        this.functionParameter = functionParameter;
    }

    public EtlLogConfig getLogConfig() {
        return this.logConfig;
    }

    public void setLogConfig(EtlLogConfig logConfig) {
        this.logConfig = logConfig;
    }

    public boolean getEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public EtlJob() {
    }

    public EtlJob(String jobName, EtlSourceConfig sourceConfig, EtlTriggerConfig triggerConfig, EtlFunctionConfig functionConfig, String functionParameter, EtlLogConfig logConfig, boolean enable) {
        this.jobName = jobName;
        this.sourceConfig = sourceConfig;
        this.triggerConfig = triggerConfig;
        this.functionConfig = functionConfig;
        this.functionParameter = functionParameter;
        this.logConfig = logConfig;
        this.enable = enable;
    }

    public JSONObject toJsonObject(boolean withJobName, boolean withSourceConfig) throws LogException {
        JSONObject etlJobJson = new JSONObject();
        if (withJobName) {
            etlJobJson.put("etlJobName", (Object)this.jobName);
        }
        if (withSourceConfig) {
            JSONObject sourceConfigJson = new JSONObject();
            sourceConfigJson.put("logstoreName", (Object)this.sourceConfig.getLogstoreName());
            etlJobJson.put("sourceConfig", (Object)sourceConfigJson);
        }
        JSONObject triggerConfigJson = new JSONObject();
        triggerConfigJson.put("roleArn", (Object)this.triggerConfig.getRoleArn());
        triggerConfigJson.put("triggerInterval", (Object)this.triggerConfig.getTriggerInterval());
        triggerConfigJson.put("maxRetryTime", (Object)this.triggerConfig.getMaxRetryTime());
        String startingPosition = this.triggerConfig.getStartingPosition();
        if (startingPosition != null) {
            triggerConfigJson.put("startingPosition", (Object)startingPosition);
            if (startingPosition.equals("at-unixtime")) {
                triggerConfigJson.put("startingUnixtime", (Object)this.triggerConfig.getStartingUnixtime());
            }
        }
        etlJobJson.put("triggerConfig", (Object)triggerConfigJson);
        JSONObject functionConfigJson = new JSONObject();
        String functionProvider = this.functionConfig.getFunctionProvider();
        functionConfigJson.put("functionProvider", (Object)functionProvider);
        if (functionProvider.equals("FunctionCompute")) {
            EtlFunctionFcConfig fcConfig = (EtlFunctionFcConfig)this.getFunctionConfig();
            functionConfigJson.put("endpoint", (Object)fcConfig.getEndpoint());
            functionConfigJson.put("accountId", (Object)fcConfig.getAccountId());
            functionConfigJson.put("regionName", (Object)fcConfig.getRegionName());
            functionConfigJson.put("serviceName", (Object)fcConfig.getServiceName());
            functionConfigJson.put("functionName", (Object)fcConfig.getFunctionName());
        }
        etlJobJson.put("functionConfig", (Object)functionConfigJson);
        try {
            JSONObject fpJsonObj = JSONObject.parseObject((String)this.functionParameter);
            etlJobJson.put("functionParameter", (Object)fpJsonObj);
        }
        catch (JSONException e) {
            throw new LogException("PostBodyInvalid", e.getMessage(), e, "");
        }
        JSONObject logConfigJson = new JSONObject();
        logConfigJson.put("endpoint", (Object)this.logConfig.getEndpoint());
        logConfigJson.put("projectName", (Object)this.logConfig.getProjectName());
        logConfigJson.put("logstoreName", (Object)this.logConfig.getLogstoreName());
        etlJobJson.put("logConfig", (Object)logConfigJson);
        etlJobJson.put("enable", (Object)this.enable);
        return etlJobJson;
    }

    public String toJsonString(boolean withJobName, boolean withSourceConfig) throws LogException {
        return this.toJsonObject(withJobName, withSourceConfig).toString();
    }

    public void fromJsonObject(JSONObject etljobJson) throws LogException {
        try {
            EtlFunctionConfig functionConfig;
            JSONObject sourceConfigJson = etljobJson.getJSONObject("sourceConfig");
            EtlSourceConfig sourceConfig = new EtlSourceConfig(sourceConfigJson.getString("logstoreName"));
            this.setSourceConfig(sourceConfig);
            JSONObject triggerConfigJson = etljobJson.getJSONObject("triggerConfig");
            EtlTriggerConfig triggerConfig = new EtlTriggerConfig(triggerConfigJson.getString("roleArn"), triggerConfigJson.getIntValue("triggerInterval"), triggerConfigJson.getIntValue("maxRetryTime"));
            if (triggerConfigJson.containsKey((Object)"startingPosition")) {
                triggerConfig.setStartingPosition(triggerConfigJson.getString("startingPosition"));
            }
            if (triggerConfigJson.containsKey((Object)"startingUnixtime")) {
                triggerConfig.setStartingPosition(triggerConfigJson.getString("startingUnixtime"));
            }
            this.setTriggerConfig(triggerConfig);
            JSONObject functionConfigJson = etljobJson.getJSONObject("functionConfig");
            String functionProvider = functionConfigJson.getString("functionProvider");
            if (functionProvider.equals("FunctionCompute")) {
                functionConfig = new EtlFunctionFcConfig(functionProvider, functionConfigJson.getString("endpoint"), functionConfigJson.getString("accountId"), functionConfigJson.getString("regionName"), functionConfigJson.getString("serviceName"), functionConfigJson.getString("functionName"));
                this.setFunctionConfig(functionConfig);
            } else {
                functionConfig = new EtlFunctionConfig(functionProvider);
                this.setFunctionConfig(functionConfig);
            }
            JSONObject logConfigJson = etljobJson.getJSONObject("logConfig");
            EtlLogConfig logConfig = new EtlLogConfig(logConfigJson.getString("endpoint"), logConfigJson.getString("projectName"), logConfigJson.getString("logstoreName"));
            this.setLogConfig(logConfig);
            this.setFunctionParameter(etljobJson.getJSONObject("functionParameter").toString());
            this.setJobName(etljobJson.getString("etlJobName"));
            this.setEnable(etljobJson.getBoolean("enable"));
        }
        catch (JSONException e) {
            throw new LogException("ParseEtlJobFail", e.getMessage(), e, "");
        }
    }
}

