/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.sample;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.Client;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.AliyunOSSSource;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.DelimitedTextFormat;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.Ingestion;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.IngestionConfiguration;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.JobSchedule;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.JobScheduleType;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.exception.LogException;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.request.CreateIngestionRequest;

class OSSIngestionSample {
    private final String endPoint = "your_endpoint";
    private final String accessId = "your_access_id";
    private final String accessKey = "your_access_key";
    private final String roleARN = "your_roleARN";
    private final Client client = new Client("your_endpoint", "your_access_id", "your_access_key");
    private final String project = "your_project_name";
    private final String logStore = "your_log_store";
    private final String bucket = "your_bucket_name";
    private final String displayName = "your_display_name";
    private final String encoding = "UTF-8";
    private final String interval = "1h";
    private final String escapeChar = "\\";
    private final String quoteChar = "\"";
    private final String fieldDelimiter = "\"";
    private final boolean firstRowAsHeader = true;
    private final boolean enable = true;
    private final int skipLeadingRows = 0;

    public void testOSSIngestion() {
        Ingestion ingestion = this.createOSSIngestion();
        try {
            this.client.createIngestion(new CreateIngestionRequest("your_project_name", ingestion));
        }
        catch (LogException e) {
            System.err.println("Create OSS Ingestion Error ! " + e.GetErrorMessage());
        }
    }

    private Ingestion createOSSIngestion() {
        Ingestion ingestion = new Ingestion();
        String jobName = OSSIngestionSample.getIngestionName();
        ingestion.setName(jobName);
        ingestion.setDisplayName("your_display_name");
        IngestionConfiguration configuration = new IngestionConfiguration();
        configuration.setLogstore("your_log_store");
        AliyunOSSSource source = new AliyunOSSSource();
        source.setBucket("your_bucket_name");
        source.setEncoding("UTF-8");
        source.setEndpoint("your_endpoint");
        source.setRoleARN("your_roleARN");
        DelimitedTextFormat format2 = new DelimitedTextFormat();
        format2.setEscapeChar("\\");
        format2.setFirstRowAsHeader(true);
        format2.setSkipLeadingRows(0);
        format2.setQuoteChar("\"");
        format2.setFieldDelimiter("\"");
        source.setFormat(format2);
        source.setRestoreObjectEnabled(true);
        source.setCompressionCodec("Gzip");
        configuration.setSource(source);
        ingestion.setConfiguration(configuration);
        JobSchedule schedule = new JobSchedule();
        schedule.setInterval("1h");
        schedule.setType(JobScheduleType.FIXED_RATE);
        ingestion.setSchedule(schedule);
        return ingestion;
    }

    private static String getIngestionName() {
        return "ingestion-" + (int)(System.currentTimeMillis() / 1000L);
    }
}

