/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.google.common.cache;

import com.alibaba.schedulerx.shade.com.google.common.annotations.GwtIncompatible;
import com.alibaba.schedulerx.shade.com.google.common.cache.AbstractCache;
import com.alibaba.schedulerx.shade.com.google.common.cache.ElementTypesAreNonnullByDefault;
import com.alibaba.schedulerx.shade.com.google.common.cache.LoadingCache;
import com.alibaba.schedulerx.shade.com.google.common.collect.ImmutableMap;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.shade.com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutionException;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class AbstractLoadingCache<K, V>
extends AbstractCache<K, V>
implements LoadingCache<K, V> {
    protected AbstractLoadingCache() {
    }

    @Override
    @CanIgnoreReturnValue
    public V getUnchecked(K key) {
        try {
            return this.get(key);
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException(e.getCause());
        }
    }

    @Override
    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
        LinkedHashMap result2 = Maps.newLinkedHashMap();
        for (K key : keys) {
            if (result2.containsKey(key)) continue;
            result2.put(key, this.get(key));
        }
        return ImmutableMap.copyOf(result2);
    }

    @Override
    public final V apply(K key) {
        return this.getUnchecked(key);
    }

    @Override
    public void refresh(K key) {
        throw new UnsupportedOperationException();
    }
}

