/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.google.common.graph;

import com.alibaba.schedulerx.shade.com.google.common.annotations.Beta;
import com.alibaba.schedulerx.shade.com.google.common.base.Optional;
import com.alibaba.schedulerx.shade.com.google.common.base.Preconditions;
import com.alibaba.schedulerx.shade.com.google.common.graph.AbstractGraphBuilder;
import com.alibaba.schedulerx.shade.com.google.common.graph.ElementOrder;
import com.alibaba.schedulerx.shade.com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.alibaba.schedulerx.shade.com.google.common.graph.Graphs;
import com.alibaba.schedulerx.shade.com.google.common.graph.ImmutableValueGraph;
import com.alibaba.schedulerx.shade.com.google.common.graph.MutableValueGraph;
import com.alibaba.schedulerx.shade.com.google.common.graph.StandardMutableValueGraph;
import com.alibaba.schedulerx.shade.com.google.common.graph.ValueGraph;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

@ElementTypesAreNonnullByDefault
@Beta
public final class ValueGraphBuilder<N, V>
extends AbstractGraphBuilder<N> {
    private ValueGraphBuilder(boolean directed) {
        super(directed);
    }

    public static ValueGraphBuilder<Object, Object> directed() {
        return new ValueGraphBuilder<Object, Object>(true);
    }

    public static ValueGraphBuilder<Object, Object> undirected() {
        return new ValueGraphBuilder<Object, Object>(false);
    }

    public static <N, V> ValueGraphBuilder<N, V> from(ValueGraph<N, V> graph) {
        return new ValueGraphBuilder<N, V>(graph.isDirected()).allowsSelfLoops(graph.allowsSelfLoops()).nodeOrder(graph.nodeOrder()).incidentEdgeOrder(graph.incidentEdgeOrder());
    }

    public <N1 extends N, V1 extends V> ImmutableValueGraph.Builder<N1, V1> immutable() {
        ValueGraphBuilder<N1, V1> castBuilder = this.cast();
        return new ImmutableValueGraph.Builder<N1, V1>(castBuilder);
    }

    @CanIgnoreReturnValue
    public ValueGraphBuilder<N, V> allowsSelfLoops(boolean allowsSelfLoops) {
        this.allowsSelfLoops = allowsSelfLoops;
        return this;
    }

    @CanIgnoreReturnValue
    public ValueGraphBuilder<N, V> expectedNodeCount(int expectedNodeCount) {
        this.expectedNodeCount = Optional.of(Graphs.checkNonNegative(expectedNodeCount));
        return this;
    }

    public <N1 extends N> ValueGraphBuilder<N1, V> nodeOrder(ElementOrder<N1> nodeOrder) {
        ValueGraphBuilder newBuilder2 = this.cast();
        newBuilder2.nodeOrder = Preconditions.checkNotNull(nodeOrder);
        return newBuilder2;
    }

    public <N1 extends N> ValueGraphBuilder<N1, V> incidentEdgeOrder(ElementOrder<N1> incidentEdgeOrder) {
        Preconditions.checkArgument(incidentEdgeOrder.type() == ElementOrder.Type.UNORDERED || incidentEdgeOrder.type() == ElementOrder.Type.STABLE, "The given elementOrder (%s) is unsupported. incidentEdgeOrder() only supports ElementOrder.unordered() and ElementOrder.stable().", incidentEdgeOrder);
        ValueGraphBuilder newBuilder2 = this.cast();
        newBuilder2.incidentEdgeOrder = Preconditions.checkNotNull(incidentEdgeOrder);
        return newBuilder2;
    }

    public <N1 extends N, V1 extends V> MutableValueGraph<N1, V1> build() {
        return new StandardMutableValueGraph(this);
    }

    ValueGraphBuilder<N, V> copy() {
        ValueGraphBuilder<N, V> newBuilder2 = new ValueGraphBuilder<N, V>(this.directed);
        newBuilder2.allowsSelfLoops = this.allowsSelfLoops;
        newBuilder2.nodeOrder = this.nodeOrder;
        newBuilder2.expectedNodeCount = this.expectedNodeCount;
        newBuilder2.incidentEdgeOrder = this.incidentEdgeOrder;
        return newBuilder2;
    }

    private <N1 extends N, V1 extends V> ValueGraphBuilder<N1, V1> cast() {
        return this;
    }
}

