/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.google.common.hash;

import com.alibaba.schedulerx.shade.com.google.common.base.Preconditions;
import com.alibaba.schedulerx.shade.com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.alibaba.schedulerx.shade.com.google.common.hash.Funnel;
import com.alibaba.schedulerx.shade.com.google.common.hash.HashCode;
import com.alibaba.schedulerx.shade.com.google.common.hash.HashFunction;
import com.alibaba.schedulerx.shade.com.google.common.hash.Hasher;
import com.alibaba.schedulerx.shade.com.google.common.hash.ParametricNullness;
import com.google.errorprone.annotations.Immutable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

@Immutable
@ElementTypesAreNonnullByDefault
abstract class AbstractHashFunction
implements HashFunction {
    AbstractHashFunction() {
    }

    @Override
    public <T> HashCode hashObject(@ParametricNullness T instance, Funnel<? super T> funnel) {
        return this.newHasher().putObject(instance, funnel).hash();
    }

    @Override
    public HashCode hashUnencodedChars(CharSequence input2) {
        int len2 = input2.length();
        return this.newHasher(len2 * 2).putUnencodedChars(input2).hash();
    }

    @Override
    public HashCode hashString(CharSequence input2, Charset charset) {
        return this.newHasher().putString(input2, charset).hash();
    }

    @Override
    public HashCode hashInt(int input2) {
        return this.newHasher(4).putInt(input2).hash();
    }

    @Override
    public HashCode hashLong(long input2) {
        return this.newHasher(8).putLong(input2).hash();
    }

    @Override
    public HashCode hashBytes(byte[] input2) {
        return this.hashBytes(input2, 0, input2.length);
    }

    @Override
    public HashCode hashBytes(byte[] input2, int off, int len2) {
        Preconditions.checkPositionIndexes(off, off + len2, input2.length);
        return this.newHasher(len2).putBytes(input2, off, len2).hash();
    }

    @Override
    public HashCode hashBytes(ByteBuffer input2) {
        return this.newHasher(input2.remaining()).putBytes(input2).hash();
    }

    @Override
    public Hasher newHasher(int expectedInputSize) {
        Preconditions.checkArgument(expectedInputSize >= 0, "expectedInputSize must be >= 0 but was %s", expectedInputSize);
        return this.newHasher();
    }
}

