/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.google.common.hash;

import com.alibaba.schedulerx.shade.com.google.common.base.Preconditions;
import com.alibaba.schedulerx.shade.com.google.common.hash.AbstractByteHasher;
import com.alibaba.schedulerx.shade.com.google.common.hash.AbstractHashFunction;
import com.alibaba.schedulerx.shade.com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.alibaba.schedulerx.shade.com.google.common.hash.HashCode;
import com.alibaba.schedulerx.shade.com.google.common.hash.Hasher;
import com.alibaba.schedulerx.shade.com.google.common.hash.ImmutableSupplier;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.util.zip.Checksum;

@Immutable
@ElementTypesAreNonnullByDefault
final class ChecksumHashFunction
extends AbstractHashFunction
implements Serializable {
    private final ImmutableSupplier<? extends Checksum> checksumSupplier;
    private final int bits;
    private final String toString;
    private static final long serialVersionUID = 0L;

    ChecksumHashFunction(ImmutableSupplier<? extends Checksum> checksumSupplier, int bits2, String toString2) {
        this.checksumSupplier = Preconditions.checkNotNull(checksumSupplier);
        Preconditions.checkArgument(bits2 == 32 || bits2 == 64, "bits (%s) must be either 32 or 64", bits2);
        this.bits = bits2;
        this.toString = Preconditions.checkNotNull(toString2);
    }

    @Override
    public int bits() {
        return this.bits;
    }

    @Override
    public Hasher newHasher() {
        return new ChecksumHasher((Checksum)this.checksumSupplier.get());
    }

    public String toString() {
        return this.toString;
    }

    private final class ChecksumHasher
    extends AbstractByteHasher {
        private final Checksum checksum;

        private ChecksumHasher(Checksum checksum) {
            this.checksum = Preconditions.checkNotNull(checksum);
        }

        @Override
        protected void update(byte b) {
            this.checksum.update(b);
        }

        @Override
        protected void update(byte[] bytes, int off, int len2) {
            this.checksum.update(bytes, off, len2);
        }

        @Override
        public HashCode hash() {
            long value = this.checksum.getValue();
            if (ChecksumHashFunction.this.bits == 32) {
                return HashCode.fromInt((int)value);
            }
            return HashCode.fromLong(value);
        }
    }
}

