/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.http.entity.mime;

import com.alibaba.schedulerx.shade.org.apache.http.entity.ContentType;
import com.alibaba.schedulerx.shade.org.apache.http.entity.mime.Header;
import com.alibaba.schedulerx.shade.org.apache.http.entity.mime.MinimalField;
import com.alibaba.schedulerx.shade.org.apache.http.entity.mime.content.AbstractContentBody;
import com.alibaba.schedulerx.shade.org.apache.http.entity.mime.content.ContentBody;
import com.alibaba.schedulerx.shade.org.apache.http.util.Args;

public class FormBodyPart {
    private final String name;
    private final Header header;
    private final ContentBody body;

    FormBodyPart(String name, ContentBody body2, Header header) {
        Args.notNull(name, "Name");
        Args.notNull(body2, "Body");
        this.name = name;
        this.body = body2;
        this.header = header != null ? header : new Header();
    }

    @Deprecated
    public FormBodyPart(String name, ContentBody body2) {
        Args.notNull(name, "Name");
        Args.notNull(body2, "Body");
        this.name = name;
        this.body = body2;
        this.header = new Header();
        this.generateContentDisp(body2);
        this.generateContentType(body2);
        this.generateTransferEncoding(body2);
    }

    public String getName() {
        return this.name;
    }

    public ContentBody getBody() {
        return this.body;
    }

    public Header getHeader() {
        return this.header;
    }

    public void addField(String name, String value) {
        Args.notNull(name, "Field name");
        this.header.addField(new MinimalField(name, value));
    }

    @Deprecated
    protected void generateContentDisp(ContentBody body2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("form-data; name=\"");
        buffer.append(this.getName());
        buffer.append("\"");
        if (body2.getFilename() != null) {
            buffer.append("; filename=\"");
            buffer.append(body2.getFilename());
            buffer.append("\"");
        }
        this.addField("Content-Disposition", buffer.toString());
    }

    @Deprecated
    protected void generateContentType(ContentBody body2) {
        ContentType contentType = body2 instanceof AbstractContentBody ? ((AbstractContentBody)body2).getContentType() : null;
        if (contentType != null) {
            this.addField("Content-Type", contentType.toString());
        } else {
            StringBuilder buffer = new StringBuilder();
            buffer.append(body2.getMimeType());
            if (body2.getCharset() != null) {
                buffer.append("; charset=");
                buffer.append(body2.getCharset());
            }
            this.addField("Content-Type", buffer.toString());
        }
    }

    @Deprecated
    protected void generateTransferEncoding(ContentBody body2) {
        this.addField("Content-Transfer-Encoding", body2.getTransferEncoding());
    }
}

