/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.http.nio.protocol;

import com.alibaba.schedulerx.shade.org.apache.http.ContentTooLongException;
import com.alibaba.schedulerx.shade.org.apache.http.HttpEntity;
import com.alibaba.schedulerx.shade.org.apache.http.HttpResponse;
import com.alibaba.schedulerx.shade.org.apache.http.entity.ContentType;
import com.alibaba.schedulerx.shade.org.apache.http.nio.ContentDecoder;
import com.alibaba.schedulerx.shade.org.apache.http.nio.IOControl;
import com.alibaba.schedulerx.shade.org.apache.http.nio.entity.ContentBufferEntity;
import com.alibaba.schedulerx.shade.org.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import com.alibaba.schedulerx.shade.org.apache.http.nio.util.HeapByteBufferAllocator;
import com.alibaba.schedulerx.shade.org.apache.http.nio.util.SimpleInputBuffer;
import com.alibaba.schedulerx.shade.org.apache.http.protocol.HttpContext;
import com.alibaba.schedulerx.shade.org.apache.http.util.Asserts;
import java.io.IOException;

public class BasicAsyncResponseConsumer
extends AbstractAsyncResponseConsumer<HttpResponse> {
    private static final int MAX_INITIAL_BUFFER_SIZE = 262144;
    private volatile HttpResponse response;
    private volatile SimpleInputBuffer buf;

    @Override
    protected void onResponseReceived(HttpResponse response) throws IOException {
        this.response = response;
    }

    @Override
    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        long len2 = entity.getContentLength();
        if (len2 > Integer.MAX_VALUE) {
            throw new ContentTooLongException("Entity content is too long: %,d", len2);
        }
        if (len2 < 0L) {
            len2 = 4096L;
        }
        int initialBufferSize = Math.min((int)len2, 262144);
        this.buf = new SimpleInputBuffer(initialBufferSize, new HeapByteBufferAllocator());
        this.response.setEntity(new ContentBufferEntity(entity, this.buf));
    }

    @Override
    protected void onContentReceived(ContentDecoder decoder, IOControl ioControl) throws IOException {
        Asserts.notNull(this.buf, "Content buffer");
        this.buf.consumeContent(decoder);
    }

    @Override
    protected void releaseResources() {
        this.response = null;
        this.buf = null;
    }

    @Override
    protected HttpResponse buildResult(HttpContext context) {
        return this.response;
    }
}

