/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.http.nio.reactor.ssl;

import com.alibaba.schedulerx.shade.org.apache.http.nio.reactor.ssl.SSLBuffer;
import com.alibaba.schedulerx.shade.org.apache.http.nio.reactor.ssl.SSLBufferManagementStrategy;
import com.alibaba.schedulerx.shade.org.apache.http.util.Args;
import java.nio.ByteBuffer;

public class ReleasableSSLBufferManagementStrategy
implements SSLBufferManagementStrategy {
    @Override
    public SSLBuffer constructBuffer(int size2) {
        return new InternalBuffer(size2);
    }

    private static final class InternalBuffer
    implements SSLBuffer {
        private ByteBuffer wrapped;
        private final int length;

        public InternalBuffer(int size2) {
            Args.positive(size2, "size");
            this.length = size2;
        }

        @Override
        public ByteBuffer acquire() {
            if (this.wrapped != null) {
                return this.wrapped;
            }
            this.wrapped = ByteBuffer.allocate(this.length);
            return this.wrapped;
        }

        @Override
        public void release() {
            this.wrapped = null;
        }

        @Override
        public boolean isAcquired() {
            return this.wrapped != null;
        }

        @Override
        public boolean hasData() {
            return this.wrapped != null && this.wrapped.position() > 0;
        }
    }
}

