/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.bnf.context;

import com.alibaba.schedulerx.shade.org.h2.bnf.context.DbSchema;
import com.alibaba.schedulerx.shade.org.h2.command.Parser;
import com.alibaba.schedulerx.shade.org.h2.util.New;
import com.alibaba.schedulerx.shade.org.h2.util.StringUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.ArrayList;

public class DbContents {
    private DbSchema[] schemas;
    private DbSchema defaultSchema;
    private boolean isOracle;
    private boolean isH2;
    private boolean isPostgreSQL;
    private boolean isDerby;
    private boolean isSQLite;
    private boolean isH2ModeMySQL;
    private boolean isMySQL;
    private boolean isFirebird;
    private boolean isMSSQLServer;
    private boolean isDB2;

    public DbSchema getDefaultSchema() {
        return this.defaultSchema;
    }

    public boolean isDerby() {
        return this.isDerby;
    }

    public boolean isFirebird() {
        return this.isFirebird;
    }

    public boolean isH2() {
        return this.isH2;
    }

    public boolean isH2ModeMySQL() {
        return this.isH2ModeMySQL;
    }

    public boolean isMSSQLServer() {
        return this.isMSSQLServer;
    }

    public boolean isMySQL() {
        return this.isMySQL;
    }

    public boolean isOracle() {
        return this.isOracle;
    }

    public boolean isPostgreSQL() {
        return this.isPostgreSQL;
    }

    public boolean isSQLite() {
        return this.isSQLite;
    }

    public boolean isDB2() {
        return this.isDB2;
    }

    public DbSchema[] getSchemas() {
        return this.schemas;
    }

    public synchronized void readContents(String string2, Connection connection) throws SQLException {
        Object object;
        Wrapper wrapper;
        this.isH2 = string2.startsWith("jdbc:h2:");
        if (this.isH2) {
            wrapper = connection.prepareStatement("SELECT UPPER(VALUE) FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME=?");
            wrapper.setString(1, "MODE");
            object = wrapper.executeQuery();
            object.next();
            if ("MYSQL".equals(object.getString(1))) {
                this.isH2ModeMySQL = true;
            }
            object.close();
            wrapper.close();
        }
        this.isDB2 = string2.startsWith("jdbc:db2:");
        this.isSQLite = string2.startsWith("jdbc:sqlite:");
        this.isOracle = string2.startsWith("jdbc:oracle:");
        this.isPostgreSQL = string2.startsWith("jdbc:postgresql:") || string2.startsWith("jdbc:vertica:");
        this.isMySQL = string2.startsWith("jdbc:mysql:");
        this.isDerby = string2.startsWith("jdbc:derby:");
        this.isFirebird = string2.startsWith("jdbc:firebirdsql:");
        this.isMSSQLServer = string2.startsWith("jdbc:sqlserver:");
        wrapper = connection.getMetaData();
        object = this.getDefaultSchemaName((DatabaseMetaData)wrapper);
        String[] stringArray = this.getSchemaNames((DatabaseMetaData)wrapper);
        this.schemas = new DbSchema[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            DbSchema[] dbSchemaArray = stringArray[i];
            int n = object == null || ((String)object).equals(dbSchemaArray) ? 1 : 0;
            DbSchema dbSchema = new DbSchema(this, (String)dbSchemaArray, n != 0);
            if (n != 0) {
                this.defaultSchema = dbSchema;
            }
            this.schemas[i] = dbSchema;
            String[] stringArray2 = new String[]{"TABLE", "SYSTEM TABLE", "VIEW", "SYSTEM VIEW", "TABLE LINK", "SYNONYM", "EXTERNAL"};
            dbSchema.readTables((DatabaseMetaData)wrapper, stringArray2);
            if (this.isPostgreSQL || this.isDB2) continue;
            dbSchema.readProcedures((DatabaseMetaData)wrapper);
        }
        if (this.defaultSchema == null) {
            String string3 = null;
            for (DbSchema dbSchema : this.schemas) {
                if ("dbo".equals(dbSchema.name)) {
                    this.defaultSchema = dbSchema;
                    break;
                }
                if (this.defaultSchema != null && string3 != null && dbSchema.name.length() >= string3.length()) continue;
                string3 = dbSchema.name;
                this.defaultSchema = dbSchema;
            }
        }
    }

    private String[] getSchemaNames(DatabaseMetaData databaseMetaData) throws SQLException {
        if (this.isMySQL || this.isSQLite) {
            return new String[]{""};
        }
        if (this.isFirebird) {
            return new String[]{null};
        }
        ResultSet resultSet = databaseMetaData.getSchemas();
        ArrayList<String> arrayList = New.arrayList();
        while (resultSet.next()) {
            String string2 = resultSet.getString("TABLE_SCHEM");
            String[] stringArray = null;
            if (this.isOracle) {
                stringArray = new String[]{"CTXSYS", "DIP", "DBSNMP", "DMSYS", "EXFSYS", "FLOWS_020100", "FLOWS_FILES", "MDDATA", "MDSYS", "MGMT_VIEW", "OLAPSYS", "ORDSYS", "ORDPLUGINS", "OUTLN", "SI_INFORMTN_SCHEMA", "SYS", "SYSMAN", "SYSTEM", "TSMSYS", "WMSYS", "XDB"};
            } else if (this.isMSSQLServer) {
                stringArray = new String[]{"sys", "db_accessadmin", "db_backupoperator", "db_datareader", "db_datawriter", "db_ddladmin", "db_denydatareader", "db_denydatawriter", "db_owner", "db_securityadmin"};
            } else if (this.isDB2) {
                stringArray = new String[]{"NULLID", "SYSFUN", "SYSIBMINTERNAL", "SYSIBMTS", "SYSPROC", "SYSPUBLIC", "SYSCAT", "SYSIBM", "SYSIBMADM", "SYSSTAT", "SYSTOOLS"};
            }
            if (stringArray != null) {
                for (void var9_9 : stringArray) {
                    if (!var9_9.equals(string2)) continue;
                    string2 = null;
                    break;
                }
            }
            if (string2 == null) continue;
            arrayList.add(string2);
        }
        resultSet.close();
        return arrayList.toArray(new String[0]);
    }

    private String getDefaultSchemaName(DatabaseMetaData databaseMetaData) {
        String string2 = "";
        try {
            if (this.isOracle) {
                return databaseMetaData.getUserName();
            }
            if (this.isPostgreSQL) {
                return "public";
            }
            if (this.isMySQL) {
                return "";
            }
            if (this.isDerby) {
                return StringUtils.toUpperEnglish(databaseMetaData.getUserName());
            }
            if (this.isFirebird) {
                return null;
            }
            ResultSet resultSet = databaseMetaData.getSchemas();
            int n = resultSet.findColumn("IS_DEFAULT");
            while (resultSet.next()) {
                if (!resultSet.getBoolean(n)) continue;
                string2 = resultSet.getString("TABLE_SCHEM");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return string2;
    }

    public String quoteIdentifier(String string2) {
        if (string2 == null) {
            return null;
        }
        if (this.isH2 && !this.isH2ModeMySQL) {
            return Parser.quoteIdentifier(string2);
        }
        return StringUtils.toUpperEnglish(string2);
    }
}

