/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.command.dml;

import com.alibaba.schedulerx.shade.org.h2.command.Prepared;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.expression.Expression;
import com.alibaba.schedulerx.shade.org.h2.expression.ExpressionVisitor;
import com.alibaba.schedulerx.shade.org.h2.result.ResultInterface;
import com.alibaba.schedulerx.shade.org.h2.result.Row;
import com.alibaba.schedulerx.shade.org.h2.result.RowList;
import com.alibaba.schedulerx.shade.org.h2.table.PlanItem;
import com.alibaba.schedulerx.shade.org.h2.table.Table;
import com.alibaba.schedulerx.shade.org.h2.table.TableFilter;
import com.alibaba.schedulerx.shade.org.h2.util.StringUtils;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import com.alibaba.schedulerx.shade.org.h2.value.ValueNull;

public class Delete
extends Prepared {
    private Expression condition;
    private TableFilter targetTableFilter;
    private Expression limitExpr;
    private TableFilter sourceTableFilter;

    public Delete(Session session) {
        super(session);
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.targetTableFilter = tableFilter;
    }

    public void setCondition(Expression expression) {
        this.condition = expression;
    }

    public Expression getCondition() {
        return this.condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        Value value;
        this.targetTableFilter.startQuery(this.session);
        this.targetTableFilter.reset();
        Table table = this.targetTableFilter.getTable();
        this.session.getUser().checkRight(table, 2);
        table.fire(this.session, 4, true);
        table.lock(this.session, true, false);
        RowList rowList = new RowList(this.session);
        int n = -1;
        if (this.limitExpr != null && (value = this.limitExpr.getValue(this.session)) != ValueNull.INSTANCE) {
            n = value.getInt();
        }
        try {
            this.setCurrentRowNumber(0);
            int n2 = 0;
            while (n != 0 && this.targetTableFilter.next()) {
                this.setCurrentRowNumber(rowList.size() + 1);
                if (this.condition != null && !this.condition.getBooleanValue(this.session)) continue;
                Row row = this.targetTableFilter.get();
                boolean bl = false;
                if (table.fireRow()) {
                    bl = table.fireBeforeRow(this.session, row, null);
                }
                if (!bl) {
                    rowList.add(row);
                }
                if (n < 0 || ++n2 < n) continue;
                break;
            }
            int n3 = 0;
            rowList.reset();
            while (rowList.hasNext()) {
                if ((++n3 & 0x7F) == 0) {
                    this.checkCanceled();
                }
                Row row = rowList.next();
                table.removeRow(this.session, row);
                this.session.log(table, (short)1, row);
            }
            if (table.fireRow()) {
                rowList.reset();
                while (rowList.hasNext()) {
                    Row row = rowList.next();
                    table.fireAfterRow(this.session, row, null, false);
                }
            }
            table.fire(this.session, 4, false);
            int n4 = n2;
            return n4;
        }
        finally {
            rowList.close();
        }
    }

    @Override
    public String getPlanSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DELETE ");
        stringBuilder.append("FROM ").append(this.targetTableFilter.getPlanSQL(false));
        if (this.condition != null) {
            stringBuilder.append("\nWHERE ").append(StringUtils.unEnclose(this.condition.getSQL()));
        }
        if (this.limitExpr != null) {
            stringBuilder.append("\nLIMIT (").append(StringUtils.unEnclose(this.limitExpr.getSQL())).append(')');
        }
        return stringBuilder.toString();
    }

    @Override
    public void prepare() {
        if (this.condition != null) {
            this.condition.mapColumns(this.targetTableFilter, 0);
            if (this.sourceTableFilter != null) {
                this.condition.mapColumns(this.sourceTableFilter, 0);
            }
            this.condition = this.condition.optimize(this.session);
            this.condition.createIndexConditions(this.session, this.targetTableFilter);
        }
        TableFilter[] tableFilterArray = this.sourceTableFilter == null ? new TableFilter[]{this.targetTableFilter} : new TableFilter[]{this.targetTableFilter, this.sourceTableFilter};
        PlanItem planItem = this.targetTableFilter.getBestPlanItem(this.session, tableFilterArray, 0, ExpressionVisitor.allColumnsForTableFilters(tableFilterArray));
        this.targetTableFilter.setPlanItem(planItem);
        this.targetTableFilter.prepare();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 58;
    }

    public void setLimit(Expression expression) {
        this.limitExpr = expression;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    public void setSourceTableFilter(TableFilter tableFilter) {
        this.sourceTableFilter = tableFilter;
    }

    public TableFilter getTableFilter() {
        return this.targetTableFilter;
    }

    public TableFilter getSourceTableFilter() {
        return this.sourceTableFilter;
    }
}

