/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.command.dml;

import com.alibaba.schedulerx.shade.org.h2.command.Prepared;
import com.alibaba.schedulerx.shade.org.h2.engine.Database;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.expression.Expression;
import com.alibaba.schedulerx.shade.org.h2.expression.ExpressionColumn;
import com.alibaba.schedulerx.shade.org.h2.mvstore.db.MVTableEngine;
import com.alibaba.schedulerx.shade.org.h2.result.LocalResult;
import com.alibaba.schedulerx.shade.org.h2.result.ResultInterface;
import com.alibaba.schedulerx.shade.org.h2.store.PageStore;
import com.alibaba.schedulerx.shade.org.h2.table.Column;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import com.alibaba.schedulerx.shade.org.h2.value.ValueString;
import java.util.Map;
import java.util.TreeMap;

public class Explain
extends Prepared {
    private Prepared command;
    private LocalResult result;
    private boolean executeCommand;

    public Explain(Session session) {
        super(session);
    }

    public void setCommand(Prepared prepared) {
        this.command = prepared;
    }

    public Prepared getCommand() {
        return this.command;
    }

    @Override
    public void prepare() {
        this.command.prepare();
    }

    public void setExecuteCommand(boolean bl) {
        this.executeCommand = bl;
    }

    @Override
    public ResultInterface queryMeta() {
        return this.query(-1);
    }

    @Override
    protected void checkParameters() {
        if (this.executeCommand) {
            super.checkParameters();
        }
    }

    @Override
    public ResultInterface query(int n) {
        Column column = new Column("PLAN", 13);
        Database database = this.session.getDatabase();
        ExpressionColumn expressionColumn = new ExpressionColumn(database, column);
        Expression[] expressionArray = new Expression[]{expressionColumn};
        this.result = new LocalResult(this.session, expressionArray, 1);
        if (n >= 0) {
            String string2;
            if (this.executeCommand) {
                PageStore pageStore = null;
                MVTableEngine.Store store = null;
                if (database.isPersistent()) {
                    pageStore = database.getPageStore();
                    if (pageStore != null) {
                        pageStore.statisticsStart();
                    }
                    if ((store = database.getMvStore()) != null) {
                        store.statisticsStart();
                    }
                }
                if (this.command.isQuery()) {
                    this.command.query(n);
                } else {
                    this.command.update();
                }
                string2 = this.command.getPlanSQL();
                Map<String, Integer> map2 = null;
                if (pageStore != null) {
                    map2 = pageStore.statisticsEnd();
                } else if (store != null) {
                    map2 = store.statisticsEnd();
                }
                if (map2 != null) {
                    int n2 = 0;
                    for (Map.Entry<String, Integer> object : map2.entrySet()) {
                        n2 += object.getValue().intValue();
                    }
                    if (n2 > 0) {
                        map2 = new TreeMap<String, Integer>(map2);
                        StringBuilder stringBuilder = new StringBuilder();
                        if (map2.size() > 1) {
                            stringBuilder.append("total: ").append(n2).append('\n');
                        }
                        for (Map.Entry<String, Integer> entry : map2.entrySet()) {
                            int n3 = entry.getValue();
                            int n4 = (int)(100L * (long)n3 / (long)n2);
                            stringBuilder.append(entry.getKey()).append(": ").append(n3);
                            if (map2.size() > 1) {
                                stringBuilder.append(" (").append(n4).append("%)");
                            }
                            stringBuilder.append('\n');
                        }
                        string2 = string2 + "\n/*\n" + stringBuilder.toString() + "*/";
                    }
                }
            } else {
                string2 = this.command.getPlanSQL();
            }
            this.add(string2);
        }
        this.result.done();
        return this.result;
    }

    private void add(String string2) {
        Value[] valueArray = new Value[]{ValueString.get(string2)};
        this.result.addRow(valueArray);
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return this.command.isReadOnly();
    }

    @Override
    public int getType() {
        return this.executeCommand ? 86 : 60;
    }
}

