/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.expression;

import com.alibaba.schedulerx.shade.org.h2.command.Parser;
import com.alibaba.schedulerx.shade.org.h2.command.dml.Select;
import com.alibaba.schedulerx.shade.org.h2.command.dml.SelectListColumnResolver;
import com.alibaba.schedulerx.shade.org.h2.engine.Database;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.expression.Comparison;
import com.alibaba.schedulerx.shade.org.h2.expression.Expression;
import com.alibaba.schedulerx.shade.org.h2.expression.ExpressionVisitor;
import com.alibaba.schedulerx.shade.org.h2.expression.ValueExpression;
import com.alibaba.schedulerx.shade.org.h2.index.IndexCondition;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.schema.Constant;
import com.alibaba.schedulerx.shade.org.h2.schema.Schema;
import com.alibaba.schedulerx.shade.org.h2.table.Column;
import com.alibaba.schedulerx.shade.org.h2.table.ColumnResolver;
import com.alibaba.schedulerx.shade.org.h2.table.Table;
import com.alibaba.schedulerx.shade.org.h2.table.TableFilter;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import com.alibaba.schedulerx.shade.org.h2.value.ValueBoolean;
import com.alibaba.schedulerx.shade.org.h2.value.ValueEnum;
import com.alibaba.schedulerx.shade.org.h2.value.ValueNull;
import java.util.HashMap;

public class ExpressionColumn
extends Expression {
    private final Database database;
    private final String schemaName;
    private final String tableAlias;
    private String columnName;
    private ColumnResolver columnResolver;
    private int queryLevel;
    private Column column;

    public ExpressionColumn(Database database, Column column) {
        this.database = database;
        this.column = column;
        this.schemaName = null;
        this.tableAlias = null;
        this.columnName = null;
    }

    public ExpressionColumn(Database database, String string2, String string3, String string4) {
        this.database = database;
        this.schemaName = string2;
        this.tableAlias = string3;
        this.columnName = string4;
    }

    @Override
    public String getSQL() {
        String string2;
        String string3;
        boolean bl = this.database.getSettings().databaseToUpper;
        if (this.column != null) {
            string3 = this.column.getSQL();
        } else {
            String string4 = string3 = bl ? Parser.quoteIdentifier(this.columnName) : this.columnName;
        }
        if (this.tableAlias != null) {
            string2 = bl ? Parser.quoteIdentifier(this.tableAlias) : this.tableAlias;
            string3 = string2 + "." + string3;
        }
        if (this.schemaName != null) {
            string2 = bl ? Parser.quoteIdentifier(this.schemaName) : this.schemaName;
            string3 = string2 + "." + string3;
        }
        return string3;
    }

    public TableFilter getTableFilter() {
        return this.columnResolver == null ? null : this.columnResolver.getTableFilter();
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        if (this.tableAlias != null && !this.database.equalsIdentifiers(this.tableAlias, columnResolver.getTableAlias())) {
            return;
        }
        if (this.schemaName != null && !this.database.equalsIdentifiers(this.schemaName, columnResolver.getSchemaName())) {
            return;
        }
        Object object = columnResolver.getColumns();
        int n2 = ((Column[])object).length;
        for (int i = 0; i < n2; ++i) {
            Column column = object[i];
            String string2 = columnResolver.getDerivedColumnName(column);
            if (string2 == null) {
                string2 = column.getName();
            }
            if (!this.database.equalsIdentifiers(this.columnName, string2)) continue;
            this.mapColumn(columnResolver, column, n);
            return;
        }
        if (this.database.equalsIdentifiers("_ROWID_", this.columnName) && (object = columnResolver.getRowIdColumn()) != null) {
            this.mapColumn(columnResolver, (Column)object, n);
            return;
        }
        object = columnResolver.getSystemColumns();
        for (n2 = 0; object != null && n2 < ((Column[])object).length; ++n2) {
            Column column = object[n2];
            if (!this.database.equalsIdentifiers(this.columnName, column.getName())) continue;
            this.mapColumn(columnResolver, column, n);
            return;
        }
    }

    private void mapColumn(ColumnResolver columnResolver, Column column, int n) {
        if (this.columnResolver == null) {
            this.queryLevel = n;
            this.column = column;
            this.columnResolver = columnResolver;
        } else if (this.queryLevel == n && this.columnResolver != columnResolver && !(columnResolver instanceof SelectListColumnResolver)) {
            throw DbException.get(90059, this.columnName);
        }
    }

    @Override
    public Expression optimize(Session session) {
        if (this.columnResolver == null) {
            Object object;
            Schema schema = session.getDatabase().findSchema(this.tableAlias == null ? session.getCurrentSchemaName() : this.tableAlias);
            if (schema != null && (object = schema.findConstant(this.columnName)) != null) {
                return ((Constant)object).getValue();
            }
            object = this.columnName;
            if (this.tableAlias != null) {
                object = this.tableAlias + "." + (String)object;
                if (this.schemaName != null) {
                    object = this.schemaName + "." + (String)object;
                }
            }
            throw DbException.get(42122, (String)object);
        }
        return this.columnResolver.optimize(this, this.column);
    }

    @Override
    public void updateAggregate(Session session) {
        Value value = this.columnResolver.getValue(this.column);
        Select select = this.columnResolver.getSelect();
        if (select == null) {
            throw DbException.get(90016, this.getSQL());
        }
        HashMap<Expression, Object> hashMap = select.getCurrentGroup();
        if (hashMap == null) {
            return;
        }
        Value value2 = (Value)hashMap.get(this);
        if (value2 == null) {
            hashMap.put(this, value);
        } else if (!this.database.areEqual(value, value2)) {
            throw DbException.get(90016, this.getSQL());
        }
    }

    @Override
    public Value getValue(Session session) {
        Value value;
        Object object;
        Select select = this.columnResolver.getSelect();
        if (select != null && (object = select.getCurrentGroup()) != null && (value = (Value)((HashMap)object).get(this)) != null) {
            return value;
        }
        object = this.columnResolver.getValue(this.column);
        if (object == null) {
            if (select == null) {
                throw DbException.get(23502, this.getSQL());
            }
            throw DbException.get(90016, this.getSQL());
        }
        if (this.column.getEnumerators() != null && object != ValueNull.INSTANCE) {
            return ValueEnum.get(this.column.getEnumerators(), ((Value)object).getInt());
        }
        return object;
    }

    @Override
    public int getType() {
        return this.column.getType();
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
    }

    public Column getColumn() {
        return this.column;
    }

    @Override
    public int getScale() {
        return this.column.getScale();
    }

    @Override
    public long getPrecision() {
        return this.column.getPrecision();
    }

    @Override
    public int getDisplaySize() {
        return this.column.getDisplaySize();
    }

    public String getOriginalColumnName() {
        return this.columnName;
    }

    public String getOriginalTableAliasName() {
        return this.tableAlias;
    }

    @Override
    public String getColumnName() {
        return this.columnName != null ? this.columnName : this.column.getName();
    }

    @Override
    public String getSchemaName() {
        Table table = this.column.getTable();
        return table == null ? null : table.getSchema().getName();
    }

    @Override
    public String getTableName() {
        Table table = this.column.getTable();
        return table == null ? null : table.getName();
    }

    @Override
    public String getAlias() {
        if (this.column != null) {
            String string2;
            if (this.columnResolver != null && (string2 = this.columnResolver.getDerivedColumnName(this.column)) != null) {
                return string2;
            }
            return this.column.getName();
        }
        if (this.tableAlias != null) {
            return this.tableAlias + "." + this.columnName;
        }
        return this.columnName;
    }

    @Override
    public boolean isAutoIncrement() {
        return this.column.getSequence() != null;
    }

    @Override
    public int getNullable() {
        return this.column.isNullable() ? 1 : 0;
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 1: {
                return false;
            }
            case 2: 
            case 5: 
            case 8: {
                return true;
            }
            case 0: {
                return this.queryLevel < expressionVisitor.getQueryLevel();
            }
            case 3: {
                if (expressionVisitor.getQueryLevel() < this.queryLevel) {
                    return true;
                }
                if (this.getTableFilter() == null) {
                    return false;
                }
                return this.getTableFilter().isEvaluatable();
            }
            case 4: {
                expressionVisitor.addDataModificationId(this.column.getTable().getMaxDataModificationId());
                return true;
            }
            case 6: {
                return this.columnResolver != expressionVisitor.getResolver();
            }
            case 7: {
                if (this.column != null) {
                    expressionVisitor.addDependency(this.column.getTable());
                }
                return true;
            }
            case 9: {
                expressionVisitor.addColumn(this.column);
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public int getCost() {
        return 2;
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        TableFilter tableFilter2 = this.getTableFilter();
        if (tableFilter == tableFilter2 && this.column.getType() == 1) {
            IndexCondition indexCondition = IndexCondition.get(0, this, ValueExpression.get(ValueBoolean.TRUE));
            tableFilter.addIndexCondition(indexCondition);
        }
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        return new Comparison(session, 0, this, ValueExpression.get(ValueBoolean.FALSE));
    }
}

