/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.jdbc;

import com.alibaba.schedulerx.shade.org.h2.command.CommandInterface;
import com.alibaba.schedulerx.shade.org.h2.expression.ParameterInterface;
import com.alibaba.schedulerx.shade.org.h2.jdbc.JdbcPreparedStatement;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.message.Trace;
import com.alibaba.schedulerx.shade.org.h2.message.TraceObject;
import com.alibaba.schedulerx.shade.org.h2.util.MathUtils;
import com.alibaba.schedulerx.shade.org.h2.value.DataType;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

public class JdbcParameterMetaData
extends TraceObject
implements ParameterMetaData {
    private final JdbcPreparedStatement prep;
    private final int paramCount;
    private final ArrayList<? extends ParameterInterface> parameters;

    JdbcParameterMetaData(Trace trace, JdbcPreparedStatement jdbcPreparedStatement, CommandInterface commandInterface, int n) {
        this.setTrace(trace, 11, n);
        this.prep = jdbcPreparedStatement;
        this.parameters = commandInterface.getParameters();
        this.paramCount = this.parameters.size();
    }

    @Override
    public int getParameterCount() throws SQLException {
        try {
            this.debugCodeCall("getParameterCount");
            this.checkClosed();
            return this.paramCount;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getParameterMode(int n) throws SQLException {
        try {
            this.debugCodeCall("getParameterMode", n);
            this.getParameter(n);
            return 1;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getParameterType(int n) throws SQLException {
        try {
            this.debugCodeCall("getParameterType", n);
            ParameterInterface parameterInterface = this.getParameter(n);
            int n2 = parameterInterface.getType();
            if (n2 == -1) {
                n2 = 13;
            }
            return DataType.getDataType((int)n2).sqlType;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        try {
            this.debugCodeCall("getPrecision", n);
            ParameterInterface parameterInterface = this.getParameter(n);
            return MathUtils.convertLongToInt(parameterInterface.getPrecision());
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getScale(int n) throws SQLException {
        try {
            this.debugCodeCall("getScale", n);
            ParameterInterface parameterInterface = this.getParameter(n);
            return parameterInterface.getScale();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int isNullable(int n) throws SQLException {
        try {
            this.debugCodeCall("isNullable", n);
            return this.getParameter(n).getNullable();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        try {
            this.debugCodeCall("isSigned", n);
            this.getParameter(n);
            return true;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getParameterClassName(int n) throws SQLException {
        try {
            this.debugCodeCall("getParameterClassName", n);
            ParameterInterface parameterInterface = this.getParameter(n);
            int n2 = parameterInterface.getType();
            if (n2 == -1) {
                n2 = 13;
            }
            return DataType.getTypeClassName(n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getParameterTypeName(int n) throws SQLException {
        try {
            this.debugCodeCall("getParameterTypeName", n);
            ParameterInterface parameterInterface = this.getParameter(n);
            int n2 = parameterInterface.getType();
            if (n2 == -1) {
                n2 = 13;
            }
            return DataType.getDataType((int)n2).name;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private ParameterInterface getParameter(int n) {
        this.checkClosed();
        if (n < 1 || n > this.paramCount) {
            throw DbException.getInvalidValueException("param", n);
        }
        return this.parameters.get(n - 1);
    }

    private void checkClosed() {
        this.prep.checkClosed();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            if (this.isWrapperFor(clazz)) {
                return (T)this;
            }
            throw DbException.getInvalidValueException("iface", clazz);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    public String toString() {
        return this.getTraceObjectName() + ": parameterCount=" + this.paramCount;
    }
}

